/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.annotated;

import java.util.List;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.literal.InjectLiteral;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.annotated.Alpha;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.annotated.Bar;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.annotated.Bravo;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.annotated.Charlie;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.annotated.Foo;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.annotated.ModifyingExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class GetAnnotatedTypesTest
extends AbstractTest {
    @Inject
    ModifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(GetAnnotatedTypesTest.class)).withClass(InjectLiteral.class)).withExtension(ModifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_bean_discovery", id="h")})
    public void testGetAnnotatedType() {
        AnnotatedType<Foo> aplha = this.extension.getAplha();
        Assert.assertNotNull(aplha);
        Assert.assertEquals((int)aplha.getAnnotations().size(), (int)1);
        Assert.assertEquals(aplha.getAnnotations().iterator().next(), (Object)Alpha.AlphaLiteral.INSTANCE);
        Assert.assertEquals((int)aplha.getMethods().size(), (int)1);
        Assert.assertEquals((int)((AnnotatedMethod)aplha.getMethods().iterator().next()).getAnnotations().size(), (int)1);
        Assert.assertEquals(((AnnotatedMethod)aplha.getMethods().iterator().next()).getAnnotations().iterator().next(), (Object)InjectLiteral.INSTANCE);
        AnnotatedType<Foo> bravo = this.extension.getBravo();
        Assert.assertNotNull(bravo);
        Assert.assertEquals((int)bravo.getAnnotations().size(), (int)2);
        Assert.assertTrue((boolean)bravo.getAnnotations().contains(Bravo.BravoLiteral.INSTANCE));
        Assert.assertTrue((boolean)bravo.getAnnotations().contains(Any.Literal.INSTANCE));
        AnnotatedType<Foo> charlie = this.extension.getCharlie();
        Assert.assertNotNull(charlie);
        Assert.assertEquals((int)charlie.getAnnotations().size(), (int)1);
        Assert.assertEquals(charlie.getAnnotations().iterator().next(), (Object)Charlie.CharlieLiteral.INSTANCE);
        AnnotatedType<Bar> bar = this.extension.getBar();
        Assert.assertNotNull(bar);
        Assert.assertEquals((int)bar.getAnnotations().size(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_bean_discovery", id="i")})
    public void testGetAnnotatedTypes() {
        List<AnnotatedType<Foo>> allFoo = this.extension.getAllFoo();
        Assert.assertEquals((int)allFoo.size(), (int)3);
        Assert.assertTrue((boolean)allFoo.contains(this.extension.getAplha()));
        Assert.assertTrue((boolean)allFoo.contains(this.extension.getBravo()));
        Assert.assertTrue((boolean)allFoo.contains(this.extension.getCharlie()));
    }
}

