/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.bean;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.builder.BeanConfigurator;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Dangerous;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.DesireToHurtHumans;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Ghost;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Monster;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.MonsterController;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Skeleton;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Undead;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Vampire;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Weapon;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Zombie;

public class AfterBeanDiscoveryObserver
implements Extension {
    public void observeUndead(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        this.configureSkeleton(bm, (BeanConfigurator<Skeleton>)abd.addBean());
        this.configureZombie(bm, (BeanConfigurator<Zombie>)abd.addBean());
        this.configureGhost(bm, (BeanConfigurator<Ghost>)abd.addBean());
        this.configureVampire(bm, (BeanConfigurator<Vampire>)abd.addBean());
    }

    private void configureSkeleton(BeanManager bm, BeanConfigurator<Skeleton> skeleton) {
        skeleton.beanClass(Skeleton.class);
        skeleton.addQualifier((Annotation)Undead.UndeadLiteral.INSTANCE);
        skeleton.addStereotype(Monster.class);
        skeleton.scope(RequestScoped.class);
        skeleton.addTransitiveTypeClosure(Skeleton.class);
        for (AnnotatedField field : bm.createAnnotatedType(Skeleton.class).getFields()) {
            if (!field.getJavaMember().getType().equals(DesireToHurtHumans.class)) continue;
            skeleton.addInjectionPoint(bm.createInjectionPoint(field));
            break;
        }
        skeleton.produceWith(MonsterController.skeletonSupplier);
        skeleton.disposeWith(MonsterController.skeletonConsumer);
    }

    private void configureZombie(BeanManager bm, BeanConfigurator<Zombie> zombie) {
        zombie.read(bm.createAnnotatedType(Zombie.class));
        zombie.beanClass(Zombie.class);
        zombie.addQualifiers(new Annotation[]{Undead.UndeadLiteral.INSTANCE, Dangerous.DangerousLiteral.INSTANCE});
        zombie.addStereotype(Monster.class);
        zombie.scope(RequestScoped.class);
        InjectionPoint zombieWeaponIP = null;
        InjectionPoint zombieDesireIP = null;
        for (AnnotatedField field : bm.createAnnotatedType(Zombie.class).getFields()) {
            if (field.getJavaMember().getType().equals(DesireToHurtHumans.class)) {
                zombieDesireIP = bm.createInjectionPoint(field);
            }
            if (!field.getJavaMember().getType().equals(Weapon.class)) continue;
            zombieWeaponIP = bm.createInjectionPoint(field);
        }
        zombie.addInjectionPoints(new InjectionPoint[]{zombieWeaponIP, zombieDesireIP});
        zombie.produceWith(MonsterController.zombieProducingFunction);
        zombie.destroyWith(MonsterController.zombieConsumer);
        zombie.id("zombie");
    }

    private void configureGhost(BeanManager bm, BeanConfigurator<Ghost> ghost) {
        ghost.read(bm.createBeanAttributes(bm.createAnnotatedType(Ghost.class)));
        ghost.beanClass(Ghost.class);
        ghost.addQualifier((Annotation)Undead.UndeadLiteral.INSTANCE);
        ghost.addStereotype(Monster.class);
        ghost.scope(RequestScoped.class);
        InjectionPoint ghostWeaponIP = null;
        InjectionPoint ghostDesireIP = null;
        for (AnnotatedField field : bm.createAnnotatedType(Ghost.class).getFields()) {
            if (field.getJavaMember().getType().equals(DesireToHurtHumans.class)) {
                ghostDesireIP = bm.createInjectionPoint(field);
            }
            if (!field.getJavaMember().getType().equals(Weapon.class)) continue;
            ghostWeaponIP = bm.createInjectionPoint(field);
        }
        ghost.addInjectionPoint(ghostWeaponIP);
        ghost.injectionPoints(new InjectionPoint[]{ghostDesireIP});
        ghost.producing((Object)MonsterController.getGhostInstance());
    }

    private void configureVampire(BeanManager bm, BeanConfigurator<Vampire> vampire) {
        vampire.read(bm.createAnnotatedType(Vampire.class));
        vampire.beanClass(Vampire.class);
        vampire.addQualifier((Annotation)Undead.UndeadLiteral.INSTANCE);
        vampire.addStereotype(Monster.class);
        vampire.scope(RequestScoped.class);
        vampire.createWith(creationalContext -> {
            MonsterController.vampireInstanceCreated = true;
            AnnotatedType at = bm.createAnnotatedType(Vampire.class);
            BeanAttributes ba = bm.createBeanAttributes(at);
            return (Vampire)bm.createBean(ba, Vampire.class, bm.getInjectionTargetFactory(at)).create(creationalContext);
        });
    }
}

