/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.Alpha;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.AlphaQualifier;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.AlphaStereotype;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.Bravo;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.BravoDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.BravoInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.BravoInterface;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.BravoProducer;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.BravoQualifier;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.Charlie;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.CharlieInterface;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.CharlieProducer;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.CharlieQualifier;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.Delta;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.VerifyingExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-EDR2")
public class VerifyValuesTest
extends AbstractTest {
    @Inject
    private VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(VerifyValuesTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateAlternatives().clazz(new String[]{Alpha.class.getName(), BravoProducer.class.getName(), CharlieProducer.class.getName()}).up()).getOrCreateInterceptors().clazz(new String[]{BravoInterceptor.class.getName()}).up()).getOrCreateDecorators().clazz(new String[]{BravoDecorator.class.getName()}).up())).withExtension(VerifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="baa")})
    public void testManagedBeanAnnotated() {
        Annotated alphaAnnotated = this.extension.getAnnotatedMap().get(Alpha.class);
        Assert.assertNotNull((Object)alphaAnnotated);
        Assert.assertTrue((boolean)(alphaAnnotated instanceof AnnotatedType));
        AnnotatedType alphaAnnotatedType = (AnnotatedType)alphaAnnotated;
        Assert.assertEquals((Object)alphaAnnotatedType.getJavaClass(), Alpha.class);
        Assert.assertEquals((int)alphaAnnotatedType.getMethods().size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="aa"), @SpecAssertion(section="process_bean_attributes", id="ad")})
    public void testManagedBeanAttributes() {
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Alpha.class, new Annotation[]{New.Literal.of(Alpha.class)}).size(), (int)1);
        Assert.assertEquals((int)this.extension.getAlphaAttributesObserved(), (int)1);
        BeanAttributes<Alpha> attributes = this.extension.getAlphaAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals((Object)attributes.getScope(), ApplicationScoped.class);
        this.verifyName(attributes, "alpha");
        Assert.assertTrue((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, Alpha.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{AlphaStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), AlphaQualifier.class, Named.class, Any.class));
        Assert.assertNull(this.extension.getMike());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes_ee", id="bab")})
    public void testSessionBeanAnnotated() {
        Annotated deltaAnnotated = this.extension.getAnnotatedMap().get(Delta.class);
        Assert.assertNotNull((Object)deltaAnnotated);
        Assert.assertTrue((boolean)(deltaAnnotated instanceof AnnotatedType));
        AnnotatedType deltaAnnotatedType = (AnnotatedType)deltaAnnotated;
        Assert.assertEquals((Object)deltaAnnotatedType.getJavaClass(), Delta.class);
        Assert.assertEquals((int)deltaAnnotatedType.getMethods().size(), (int)1);
        Assert.assertEquals((String)((AnnotatedMethod)deltaAnnotatedType.getMethods().iterator().next()).getJavaMember().getName(), (String)"foo");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="aa"), @SpecAssertion(section="process_bean_attributes_ee", id="bab"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testSessionBeanAttributes() {
        BeanAttributes<Delta> deltaAttributes = this.extension.getDeltaAttributes();
        Assert.assertNotNull(deltaAttributes);
        Assert.assertEquals((Object)deltaAttributes.getScope(), Dependent.class);
        this.verifyName(deltaAttributes, "delta");
        Assert.assertFalse((boolean)deltaAttributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(deltaAttributes.getTypes(), new Type[]{Object.class, Delta.class}));
        Assert.assertTrue((boolean)deltaAttributes.getStereotypes().isEmpty());
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)deltaAttributes.getQualifiers(), Named.class, Any.class, Default.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="bac")})
    public void testProducerMethodAnnotated() {
        Annotated bravoAnnotated = this.extension.getAnnotatedMap().get(Bravo.class);
        Assert.assertNotNull((Object)bravoAnnotated);
        Assert.assertTrue((boolean)(bravoAnnotated instanceof AnnotatedMethod));
        AnnotatedMethod bravoAnnotatedMethod = (AnnotatedMethod)bravoAnnotated;
        Assert.assertEquals((String)bravoAnnotatedMethod.getJavaMember().getName(), (String)"createBravo");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="aa"), @SpecAssertion(section="bean_discovery_steps", id="jc")})
    public void testProducerMethodBeanAttributes() {
        BeanAttributes<Bravo> attributes = this.extension.getProducedBravoAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(RequestScoped.class, (Object)attributes.getScope());
        this.verifyName(attributes, "createBravo");
        Assert.assertTrue((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{BravoInterface.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{AlphaStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), BravoQualifier.class, Named.class, Any.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="bad")})
    public void testProducerFieldAnnotated() {
        Annotated charlieAnnotated = this.extension.getAnnotatedMap().get(Charlie.class);
        Assert.assertNotNull((Object)charlieAnnotated);
        Assert.assertTrue((boolean)(charlieAnnotated instanceof AnnotatedField));
        AnnotatedField charlieAnnotatedField = (AnnotatedField)charlieAnnotated;
        Assert.assertEquals((String)charlieAnnotatedField.getJavaMember().getName(), (String)"charlie");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="aa"), @SpecAssertion(section="bean_discovery_steps", id="jc")})
    public void testProducerFieldBeanAttributes() {
        BeanAttributes<Charlie> attributes = this.extension.getProducedCharlieAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(ApplicationScoped.class, (Object)attributes.getScope());
        this.verifyName(attributes, "charlie");
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, Charlie.class, CharlieInterface.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{AlphaStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), CharlieQualifier.class, Named.class, Any.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="ab"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testInterceptorBeanAttributes() {
        BeanAttributes<BravoInterceptor> attributes = this.extension.getBravoInterceptorAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(Dependent.class, (Object)attributes.getScope());
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, BravoInterceptor.class}));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="ac"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testDecoratorBeanAttributes() {
        BeanAttributes<BravoDecorator> attributes = this.extension.getBravoDecoratorAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(Dependent.class, (Object)attributes.getScope());
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, BravoDecorator.class, BravoInterface.class}));
        Assert.assertTrue((attributes.getStereotypes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Class)attributes.getStereotypes().iterator().next()).equals(Decorator.class));
    }

    private void verifyName(BeanAttributes<?> attributes, String name) {
        Assert.assertEquals((String)name, (String)attributes.getName());
        for (Annotation qualifier : attributes.getQualifiers()) {
            if (!Named.class.equals(qualifier.annotationType())) continue;
            Assert.assertEquals((String)name, (String)((Named)qualifier).value());
            return;
        }
        Assert.fail((String)"@Named qualifier not found.");
    }
}

