/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;

public class CustomInjectionTarget<T>
implements InjectionTarget<T> {
    private InjectionTarget<T> wrappedInjectionTarget;
    private BeanManager beanManager;

    public CustomInjectionTarget(InjectionTarget<T> originalInjectionTarget, BeanManager beanManager) {
        this.wrappedInjectionTarget = originalInjectionTarget;
        this.beanManager = beanManager;
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.beanManager.fireEvent(instance, new Annotation[0]);
        this.wrappedInjectionTarget.inject(instance, ctx);
    }

    public void postConstruct(T instance) {
        this.wrappedInjectionTarget.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.wrappedInjectionTarget.preDestroy(instance);
    }

    public Object produce(CreationalContext ctx) {
        return this.wrappedInjectionTarget.produce(ctx);
    }

    public void dispose(T instance) {
        this.wrappedInjectionTarget.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.wrappedInjectionTarget.getInjectionPoints();
    }
}

