/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder;

import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder.AccountTransaction;
import org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder.AnotherInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder.FirstInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder.Foo;
import org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder.SecondInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder.Transaction;
import org.jboss.cdi.tck.tests.interceptors.definition.interceptorOrder.TransactionalInterceptor;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class InterceptorOrderTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorOrderTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{SecondInterceptor.class.getName(), FirstInterceptor.class.getName(), TransactionalInterceptor.class.getName()}).up())).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="enabled_interceptors", id="b"), @SpecAssertion(section="enabled_interceptors", id="c")})
    public void testInterceptorsCalledInOrderDefinedByBeansXml(Foo foo) {
        Assert.assertNotNull((Object)foo);
        ActionSequence.reset();
        foo.bar();
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)sequence.size(), (int)2);
        Assert.assertEquals((String)sequence.get(0), (String)SecondInterceptor.class.getName());
        Assert.assertEquals((String)sequence.get(1), (String)FirstInterceptor.class.getName());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="enabled_interceptors", id="g")
    public void testInterceptorsInvocationOrder(AccountTransaction transaction) {
        Assert.assertNotNull((Object)transaction);
        ActionSequence.reset();
        transaction.execute();
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)sequence.size(), (int)4);
        Assert.assertEquals((String)sequence.get(0), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)sequence.get(1), (String)TransactionalInterceptor.class.getName());
        Assert.assertEquals((String)sequence.get(2), (String)Transaction.class.getName());
        Assert.assertEquals((String)sequence.get(3), (String)AccountTransaction.class.getName());
    }
}

