/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.DeluxeHenHouse;
import org.jboss.cdi.tck.tests.lookup.injection.MegaPoorHenHouse;
import org.jboss.cdi.tck.tests.lookup.injection.SpiderNest;
import org.jboss.cdi.tck.tests.lookup.injection.WolfPack;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class InjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionTest.class)).withWebXml((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createEnvEntry().envEntryName("greeting").envEntryType("java.lang.String").envEntryValue("Hello").up()).createEnvEntry().envEntryName("game").envEntryType("java.lang.String").envEntryValue("poker").up())).build();
    }

    @Test
    @SpecAssertion(section="primitive_types_and_null_values", id="aa")
    public void testInjectionPerformsBoxingIfNecessary() throws Exception {
        assert (this.getBeans(SpiderNest.class, new Annotation[0]).size() == 1);
        SpiderNest spiderNest = this.getContextualReference(SpiderNest.class, new Annotation[0]);
        assert (spiderNest.numberOfSpiders != null);
        assert (spiderNest.numberOfSpiders.equals(4));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="performing_typesafe_resolution", id="kc"), @SpecAssertion(section="injection", id="b"), @SpecAssertion(section="fields_initializer_methods", id="ac")})
    public void testInjectionOfNamedBean() {
        WolfPack wolfPack = this.getContextualReference(WolfPack.class, new Annotation[0]);
        assert (wolfPack.getAlphaWolf() != null);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="aa"), @SpecAssertion(section="fields_initializer_methods", id="bg"), @SpecAssertion(section="fields_initializer_methods", id="bh"), @SpecAssertion(section="fields_initializer_methods", id="bk"), @SpecAssertion(section="fields_initializer_methods", id="bl"), @SpecAssertion(section="fields_initializer_methods_ee", id="bi"), @SpecAssertion(section="fields_initializer_methods_ee", id="bj")})
    public void testInjectionFieldsAndInitializerMethods(DeluxeHenHouse henHouse) throws Exception {
        Assert.assertNotNull((Object)henHouse.fox);
        Assert.assertEquals((String)henHouse.fox.getName(), (String)"gavin");
        Assert.assertTrue((boolean)henHouse.initializerCalledAfterInjectionPointsInit);
        Assert.assertTrue((boolean)henHouse.postConstructCalledAfterInitializers);
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="ac")
    public void testFieldDeclaredInIndirectSuperclassInjected() throws Exception {
        MegaPoorHenHouse henHouse = this.getContextualReference(MegaPoorHenHouse.class, new Annotation[0]);
        assert (henHouse.fox != null);
        assert (henHouse.fox.getName().equals("gavin"));
    }
}

