/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.BarBazImpl;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.BarBazSuperFooImpl;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.BarSubBazFooImpl;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.Box;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.BoxBarBazFooImpl;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.Dao;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.InjectedBean;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.IntegerHashMap;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.Result;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.ResultImpl;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.SubBar;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.SubBaz;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class AssignabilityOfRawAndParameterizedTypesTest
extends AbstractTest {
    private static final Class<?>[] RESULT_TYPES = new Class[]{ResultImpl.class, Result.class, Object.class};
    private static final Class<?>[] DAO_TYPES = new Class[]{Dao.class, Object.class};
    private static final Class<?>[] BOX_TYPES = new Class[]{BoxBarBazFooImpl.class, Box.class, Object.class};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AssignabilityOfRawAndParameterizedTypesTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="performing_typesafe_resolution", id="kb"), @SpecAssertion(section="legal_bean_types", id="f"), @SpecAssertion(section="legal_bean_types", id="g"), @SpecAssertion(section="assignable_parameters", id="a")})
    public void testAssignabilityToRawType() {
        Assert.assertEquals((int)this.getBeans(Dao.class, new Annotation[0]).size(), (int)4);
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="ba")
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithActualTypes() {
        assert (this.getBeans(new TypeLiteral<Map<Integer, Integer>>(){}, new Annotation[0]).size() == 2);
        assert (this.getBeans(new TypeLiteral<HashMap<Integer, Integer>>(){}, new Annotation[0]).iterator().next().getTypes().contains(IntegerHashMap.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="assignable_parameters", id="c")})
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithWildcards() {
        assert (this.getBeans(new TypeLiteral<HashMap<? extends Number, ? super Integer>>(){}, new Annotation[0]).size() == 1);
        assert (this.getBeans(new TypeLiteral<HashMap<? extends Number, ? super Integer>>(){}, new Annotation[0]).iterator().next().getTypes().contains(IntegerHashMap.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="legal_injection_point_types", id="b")})
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithWildcardsAtInjectionPoint() {
        assert (this.getContextualReference(InjectedBean.class, new Annotation[0]).getMap() instanceof IntegerHashMap);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="assignable_parameters", id="da"), @SpecAssertion(section="assignable_parameters", id="dc")})
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithWildcards() {
        Set<Bean<Result<? extends Throwable, ? super Exception>>> beans = this.getBeans(new TypeLiteral<Result<? extends Throwable, ? super Exception>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), RESULT_TYPES));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="assignable_parameters", id="db"), @SpecAssertion(section="assignable_parameters", id="dc")})
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithWildcards2() {
        Set<Bean<Result<? extends RuntimeException, ? super RuntimeException>>> beans = this.getBeans(new TypeLiteral<Result<? extends RuntimeException, ? super RuntimeException>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), RESULT_TYPES));
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="dc")
    public <T1 extends SubBar & SubBaz, T2 extends BarBazImpl, T3 extends SubBar & SubBaz, T4 extends SubBar & SubBaz, T5 extends BarBazSuperFooImpl, T6 extends BarBazSuperFooImpl> void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithWildcardWithLowerBound() {
        Set<Bean<Result<? extends Exception, ? super Throwable>>> beans = this.getBeans(new TypeLiteral<Result<? extends Exception, ? super Throwable>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)0);
        Set beans1 = this.getBeans(new TypeLiteral<Box<? super T1>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans1.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(beans1.iterator().next().getTypes(), BOX_TYPES));
        Set beans2 = this.getBeans(new TypeLiteral<Box<? super T2>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans2.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(beans2.iterator().next().getTypes(), BOX_TYPES));
        Set noBeans3 = this.getBeans(new TypeLiteral<Box<? super T3>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans3.size(), (int)0);
        Set noBeans4 = this.getBeans(new TypeLiteral<Box<? super T4>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans4.size(), (int)0);
        Set noBeans5 = this.getBeans(new TypeLiteral<Box<? super T5>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans5.size(), (int)0);
        Set beans6 = this.getBeans(new TypeLiteral<Box<? super T6>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans6.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(beans6.iterator().next().getTypes(), BOX_TYPES));
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="e")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithActualTypes() {
        Set<Bean<Result<RuntimeException, IllegalStateException>>> beans = this.getBeans(new TypeLiteral<Result<RuntimeException, IllegalStateException>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), RESULT_TYPES));
        Set<Bean<Result<RuntimeException, Throwable>>> noBeans = this.getBeans(new TypeLiteral<Result<RuntimeException, Throwable>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans.size(), (int)0);
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="e")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesWithMultipleBoundsToParameterizedTypeWithActualTypes() {
        Set<Bean<Box<BarSubBazFooImpl>>> beans = this.getBeans(new TypeLiteral<Box<BarSubBazFooImpl>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(beans.iterator().next().getTypes(), BOX_TYPES));
        Set<Bean<Box<BarBazSuperFooImpl>>> noBeans1 = this.getBeans(new TypeLiteral<Box<BarBazSuperFooImpl>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans1.size(), (int)0);
        Set<Bean<Box<BarBazImpl>>> noBeans2 = this.getBeans(new TypeLiteral<Box<BarBazImpl>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans2.size(), (int)0);
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="f")
    public <T1 extends RuntimeException, T2 extends T1, T3> void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithTypeVariable() {
        Set beans = this.getBeans(new TypeLiteral<Result<T1, T2>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), RESULT_TYPES));
        Set noBeans = this.getBeans(new TypeLiteral<Result<T1, T3>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans.size(), (int)0);
        Set daoBeans = this.getBeans(new TypeLiteral<Dao<T1, T3>>(){}, new Annotation[0]);
        Assert.assertEquals((int)daoBeans.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(daoBeans.iterator().next().getTypes(), DAO_TYPES));
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="f")
    public <T1 extends SubBar & SubBaz, T2 extends BarBazImpl, T3 extends SubBar & SubBaz, T4 extends SubBar & SubBaz, T5 extends BarBazSuperFooImpl, T6 extends BarBazSuperFooImpl> void testAssignabilityOfParameterizedTypeWithTypeVariableWithMultipleBoundsToParameterizedTypeWithTypeVariable() {
        Set beans1 = this.getBeans(new TypeLiteral<Box<T1>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans1.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(beans1.iterator().next().getTypes(), BOX_TYPES));
        Set beans2 = this.getBeans(new TypeLiteral<Box<T2>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans2.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(beans2.iterator().next().getTypes(), BOX_TYPES));
        Set noBeans3 = this.getBeans(new TypeLiteral<Box<T3>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans3.size(), (int)0);
        Set noBeans4 = this.getBeans(new TypeLiteral<Box<T4>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans4.size(), (int)0);
        Set noBeans5 = this.getBeans(new TypeLiteral<Box<T5>>(){}, new Annotation[0]);
        Assert.assertEquals((int)noBeans5.size(), (int)0);
        Set beans6 = this.getBeans(new TypeLiteral<Box<T6>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans6.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(beans6.iterator().next().getTypes(), BOX_TYPES));
    }
}

