/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.alternative;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.alternative.Animal;
import org.jboss.cdi.tck.tests.alternative.Bird;
import org.jboss.cdi.tck.tests.alternative.Cat;
import org.jboss.cdi.tck.tests.alternative.Chicken;
import org.jboss.cdi.tck.tests.alternative.Dog;
import org.jboss.cdi.tck.tests.alternative.EnabledAlternativeStereotype;
import org.jboss.cdi.tck.tests.alternative.EnabledSheepProducer;
import org.jboss.cdi.tck.tests.alternative.Horse;
import org.jboss.cdi.tck.tests.alternative.Sheep;
import org.jboss.cdi.tck.tests.alternative.Snake;
import org.jboss.cdi.tck.tests.alternative.SnakeProducer;
import org.jboss.cdi.tck.tests.alternative.Tame;
import org.jboss.cdi.tck.tests.alternative.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class AlternativeAvailabilityTest
extends AbstractTest {
    private static final AnnotationLiteral<Wild> WILD_LITERAL = new AnnotationLiteral<Wild>(){};
    private static final AnnotationLiteral<Tame> TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlternativeAvailabilityTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateAlternatives().clazz(new String[]{Chicken.class.getName(), EnabledSheepProducer.class.getName(), SnakeProducer.class.getName()}).stereotype(new String[]{EnabledAlternativeStereotype.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="selection", id="e"), @SpecAssertion(section="declaring_selected_alternatives_bean_archive", id="ba"), @SpecAssertion(section="declaring_alternative", id="aa"), @SpecAssertion(section="bean_discovery_steps", id="g")})
    public void testAlternativeAvailability() throws Exception {
        Set<Bean<Animal>> animals = this.getBeans(Animal.class, new Annotation[0]);
        HashSet types = new HashSet();
        for (Bean<Animal> animal : animals) {
            types.addAll(animal.getTypes());
        }
        Assert.assertTrue((boolean)types.contains(Chicken.class));
        Assert.assertTrue((boolean)types.contains(Cat.class));
        Assert.assertTrue((boolean)types.contains(Bird.class));
        Assert.assertFalse((boolean)types.contains(Horse.class));
        Assert.assertFalse((boolean)types.contains(Dog.class));
        Assert.assertEquals((int)this.getCurrentManager().getBeans("cat").size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().getBeans("dog").size(), (int)0);
    }

    @Test
    @SpecAssertion(section="bean", id="bc")
    public void testIsAlternative() {
        Bean cat = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(Cat.class, new Annotation[0]));
        Assert.assertTrue((boolean)cat.isAlternative());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_selected_alternatives_bean_archive", id="d"), @SpecAssertion(section="declaring_alternative", id="ba"), @SpecAssertion(section="stereotypes", id="aa"), @SpecAssertion(section="alternative_stereotype", id="a")})
    public void testAnyEnabledAlternativeStereotypeMakesAlternativeEnabled() throws Exception {
        Assert.assertEquals((int)this.getBeans(Bird.class, new Annotation[0]).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().getBeans("bird").size(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="inter_module_injection", id="e"), @SpecAssertion(section="inter_module_injection", id="f"), @SpecAssertion(section="inter_module_injection", id="g"), @SpecAssertion(section="inter_module_injection", id="h")})
    public void testProducersOnAlternativeClass() throws Exception {
        Assert.assertEquals((int)this.getBeans(Sheep.class, new Annotation[]{WILD_LITERAL}).size(), (int)2);
        Assert.assertEquals((int)this.getBeans(Sheep.class, new Annotation[]{TAME_LITERAL}).size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_selected_alternatives_bean_archive", id="ca"), @SpecAssertion(section="declaring_selected_alternatives_bean_archive", id="cb"), @SpecAssertion(section="declaring_alternative", id="ab"), @SpecAssertion(section="declaring_alternative", id="ac")})
    public void testProducerAlternativesOnMethodAndField() throws Exception {
        Assert.assertEquals((int)this.getBeans(Cat.class, new Annotation[]{WILD_LITERAL}).size(), (int)2);
        Assert.assertEquals((int)this.getBeans(Cat.class, new Annotation[]{TAME_LITERAL}).size(), (int)0);
        Set snakeBeans = this.getCurrentManager().getBeans(Snake.class, new Annotation[]{WILD_LITERAL});
        Assert.assertNotNull((Object)this.getCurrentManager().resolve(snakeBeans));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_selected_alternatives_bean_archive", id="d"), @SpecAssertion(section="declaring_alternative", id="bb"), @SpecAssertion(section="declaring_alternative", id="bc")})
    public void testStereotypeAlternativeOnProducerMethodAndField() throws Exception {
        Assert.assertEquals((int)this.getBeans(Bird.class, new Annotation[]{WILD_LITERAL}).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Bird.class, new Annotation[]{TAME_LITERAL}).size(), (int)2);
    }
}

