/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context;

import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.context.MyContextual;
import org.jboss.cdi.tck.tests.context.MySessionBean;
import org.jboss.cdi.tck.tests.context.SimpleBeanA;
import org.jboss.cdi.tck.tests.context.SimpleBeanB;
import org.jboss.cdi.tck.util.MockCreationalContext;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class NormalContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NormalContextTest.class)).withExtension(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="j"), @SpecAssertion(section="context", id="l"), @SpecAssertion(section="normal_scope", id="c")})
    public void testGetReturnsExistingInstance() {
        Bean<MySessionBean> mySessionBean = this.getBeans(MySessionBean.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(mySessionBean);
        MySessionBean first = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, creationalContext);
        first.setId(10);
        MySessionBean second = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, creationalContext);
        assert (second.getId() == 10);
        MySessionBean third = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean);
        assert (third.getId() == 10);
        MySessionBean fourth = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, this.getCurrentManager().createCreationalContext(mySessionBean));
        assert (fourth.getId() == 10);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="l")})
    public void testGetWithCreationalContextReturnsNewInstance() {
        MyContextual bean = AfterBeanDiscoveryObserver.getBean();
        bean.setShouldReturnNullInstances(false);
        MockCreationalContext creationalContext = new MockCreationalContext();
        MySessionBean newBean = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get((Contextual)bean, creationalContext);
        assert (newBean != null);
        assert (bean.isCreateCalled());
    }

    @Test
    @SpecAssertion(section="context", id="nb")
    public void testGetMayNotReturnNullUnlessContextualCreateReturnsNull() {
        MyContextual bean = AfterBeanDiscoveryObserver.getBean();
        bean.setShouldReturnNullInstances(true);
        MockCreationalContext creationalContext = new MockCreationalContext();
        assert (this.getCurrentManager().getContext(SessionScoped.class).get((Contextual)bean, creationalContext) == null);
        assert (bean.isCreateCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="normal_scope", id="e")})
    public void testSameNormalScopeBeanInjectedEverywhere() {
        SimpleBeanA instanceOfA = this.getContextualReference(SimpleBeanA.class, new Annotation[0]);
        SimpleBeanB instanceOfB = this.getContextualReference(SimpleBeanB.class, new Annotation[0]);
        instanceOfA.getZ().setName("Ben");
        assert (instanceOfA.getZ().getName().equals("Ben"));
        assert (instanceOfB.getZ().getName().equals("Ben"));
    }
}

