/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Axe;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Equipment;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Hoe;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Mace;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Melee;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.ProcessBeanAttributesObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Reforged;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Sword;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Tool;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.TwoHanded;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.UsableItem;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Weapon;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-EDR2")
public class BeanAttributesConfiguratorTest
extends AbstractTest {
    public static final String SWORD_NAME = "Frostmourne";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanAttributesConfiguratorTest.class)).withExtension(ProcessBeanAttributesObserver.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateAlternatives().clazz(new String[]{Axe.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_attributes_configurator", id="aa"), @SpecAssertion(section="bean_attributes_configurator", id="ba"), @SpecAssertion(section="bean_attributes_configurator", id="bd"), @SpecAssertion(section="bean_attributes_configurator", id="bf"), @SpecAssertion(section="bean_attributes_configurator", id="bh")})
    public void testSingleAdditionMethods() {
        Bean<Sword> bean = this.getUniqueBean(Sword.class, TwoHanded.TwoHandedLiteral.INSTANCE);
        Assert.assertTrue((boolean)bean.getQualifiers().contains(TwoHanded.TwoHandedLiteral.INSTANCE));
        Assert.assertTrue((boolean)bean.getName().equals(SWORD_NAME));
        Assert.assertTrue((boolean)bean.getTypes().contains(Weapon.class));
        Assert.assertTrue((boolean)bean.getStereotypes().contains(Equipment.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_attributes_configurator", id="ab"), @SpecAssertion(section="bean_attributes_configurator", id="bb"), @SpecAssertion(section="bean_attributes_configurator", id="bc"), @SpecAssertion(section="bean_attributes_configurator", id="be"), @SpecAssertion(section="bean_attributes_configurator", id="bg"), @SpecAssertion(section="bean_attributes_configurator", id="bi")})
    public void testMultiAdditionMethods() {
        Bean<Axe> bean = this.getUniqueBean(Axe.class, TwoHanded.TwoHandedLiteral.INSTANCE, Reforged.ReforgedLiteral.INSTANCE);
        Set qualifiers = bean.getQualifiers();
        Set stereotypes = bean.getStereotypes();
        Set types = bean.getTypes();
        Assert.assertTrue((boolean)bean.getScope().equals(RequestScoped.class));
        Assert.assertTrue((boolean)qualifiers.containsAll(new HashSet<AnnotationLiteral>(Arrays.asList(Reforged.ReforgedLiteral.INSTANCE, TwoHanded.TwoHandedLiteral.INSTANCE))));
        Assert.assertTrue((boolean)stereotypes.containsAll(new HashSet<Class>(Arrays.asList(Melee.class, Equipment.class))));
        Assert.assertTrue((boolean)types.containsAll(new HashSet<Class>(Arrays.asList(Weapon.class, Tool.class))));
        Assert.assertTrue((boolean)bean.isAlternative());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_attributes_configurator", id="ab"), @SpecAssertion(section="bean_attributes_configurator", id="ba"), @SpecAssertion(section="bean_attributes_configurator", id="be"), @SpecAssertion(section="bean_attributes_configurator", id="bg")})
    public void testReplacementMethods() {
        Bean<Hoe> bean = this.getUniqueBean(Hoe.class, Reforged.ReforgedLiteral.INSTANCE);
        Set types = bean.getTypes();
        Set stereotypes = bean.getStereotypes();
        Assert.assertTrue((boolean)bean.getQualifiers().equals(new HashSet<AnnotationLiteral>(Arrays.asList(Reforged.ReforgedLiteral.INSTANCE, Any.Literal.INSTANCE))));
        Assert.assertTrue((boolean)types.containsAll(new HashSet<Class>(Arrays.asList(Tool.class, UsableItem.class))));
        Assert.assertTrue((boolean)stereotypes.equals(new HashSet<Class>(Arrays.asList(Equipment.class))));
    }

    @Test
    @SpecAssertion(section="process_bean_attributes", id="bca")
    public void configuratorInitializedWithOriginalBeanAttributes() {
        Bean<Mace> configuredBean = this.getUniqueBean(Mace.class, new Annotation[0]);
        BeanAttributes<Mace> originalBA = ((ProcessBeanAttributesObserver)this.getCurrentManager().getExtension(ProcessBeanAttributesObserver.class)).getOriginalBA();
        Assert.assertEquals((Set)configuredBean.getTypes(), (Set)originalBA.getTypes());
        Assert.assertEquals((Set)configuredBean.getQualifiers(), (Set)originalBA.getQualifiers());
        Assert.assertEquals((Set)configuredBean.getStereotypes(), (Set)originalBA.getStereotypes());
        Assert.assertEquals((Object)configuredBean.getScope(), (Object)originalBA.getScope());
    }
}

