/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.interceptionFactory;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.Product;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.ProductInterceptor1;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.ProductInterceptor2;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.ProductInterceptor3;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class InterceptionFactoryTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptionFactoryTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="interception_factory", id="b"), @SpecAssertion(section="interception_factory", id="c")})
    public void producedInstanceIsIntercepted(Product product) {
        ActionSequence.reset();
        Assert.assertEquals((int)3, (int)product.ping());
        ActionSequence.assertSequenceDataEquals(ProductInterceptor1.class, ProductInterceptor2.class, ProductInterceptor3.class);
    }

    @Test
    @SpecAssertion(section="interception_factory", id="g")
    public void interceptionFactoryBeanIsAvailable() {
        Bean interceptionFactoryBean = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(InterceptionFactory.class, new Annotation[0]));
        Assert.assertEquals(Dependent.class, (Object)interceptionFactoryBean.getScope());
        Assert.assertEquals(Collections.singleton(Default.Literal.INSTANCE), (Set)interceptionFactoryBean.getQualifiers());
    }
}

