/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.interceptors;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.interceptors.FullMarathon;
import org.jboss.cdi.tck.tests.extensions.interceptors.Incremented;
import org.jboss.cdi.tck.tests.extensions.interceptors.IncrementingInterceptor;
import org.jboss.cdi.tck.tests.extensions.interceptors.InterceptorExtension;
import org.jboss.cdi.tck.tests.extensions.interceptors.LifecycleInterceptor;
import org.jboss.cdi.tck.tests.extensions.interceptors.Marathon;
import org.jboss.cdi.tck.tests.extensions.interceptors.NumberSource;
import org.jboss.cdi.tck.tests.extensions.interceptors.Suffixed;
import org.jboss.cdi.tck.tests.extensions.interceptors.SuffixingInterceptor;
import org.jboss.cdi.tck.tests.extensions.interceptors.WordSource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR2")
public class InterceptorExtensionTest
extends AbstractTest {
    @Inject
    private BeanManager beanManager;
    @Inject
    private NumberSource numberSource;
    @Inject
    private WordSource wordSource;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(InterceptorExtensionTest.class)).withClasses(Marathon.class, NumberSource.class, WordSource.class)).withLibrary(SuffixingInterceptor.class, IncrementingInterceptor.class, LifecycleInterceptor.class, Suffixed.class, FullMarathon.class, Incremented.class, InterceptorExtension.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{SuffixingInterceptor.class.getName(), IncrementingInterceptor.class.getName(), LifecycleInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="init_events", id="b"), @SpecAssertion(section="init_events", id="bb"), @SpecAssertion(section="before_bean_discovery", id="ae")})
    public void testInterceptorAddedByClass() {
        Assert.assertEquals((int)this.numberSource.value(), (int)2);
        Assert.assertTrue((boolean)IncrementingInterceptor.isDoAroundCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="init_events", id="b"), @SpecAssertion(section="init_events", id="bb"), @SpecAssertion(section="before_bean_discovery", id="ae")})
    public void testLifecycleInterceptor() {
        Bean bean = (Bean)this.beanManager.getBeans(Marathon.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        Marathon marathon = (Marathon)bean.create(creationalContext);
        Assert.assertTrue((boolean)LifecycleInterceptor.isPostConstructCalled());
        Assert.assertEquals((long)marathon.getLength(), (long)42L);
        bean.destroy((Object)marathon, creationalContext);
        Assert.assertTrue((boolean)LifecycleInterceptor.isPreDestroyCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="init_events", id="b"), @SpecAssertion(section="init_events", id="bb"), @SpecAssertion(section="before_bean_discovery", id="aea")})
    public void testInterceptorAddedByAnnotatedType() {
        Assert.assertEquals((String)this.wordSource.getWord(), (String)"awesome");
        Assert.assertEquals((String)this.wordSource.getWordWithSuffix(), (String)"awesomeness");
        Assert.assertTrue((boolean)SuffixingInterceptor.isDoAroundCalled());
    }
}

