/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.AdvancedPaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.AsynchronousPaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.Baz;
import org.jboss.cdi.tck.tests.lookup.dynamic.Common;
import org.jboss.cdi.tck.tests.lookup.dynamic.Corge;
import org.jboss.cdi.tck.tests.lookup.dynamic.Garply;
import org.jboss.cdi.tck.tests.lookup.dynamic.NonBinding;
import org.jboss.cdi.tck.tests.lookup.dynamic.ObtainsInstanceBean;
import org.jboss.cdi.tck.tests.lookup.dynamic.ObtainsNewInstanceBean;
import org.jboss.cdi.tck.tests.lookup.dynamic.PayBy;
import org.jboss.cdi.tck.tests.lookup.dynamic.PayByBinding;
import org.jboss.cdi.tck.tests.lookup.dynamic.PaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.RemotePaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.Uncommon;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class DynamicLookupTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DynamicLookupTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="aa")})
    public void testObtainsInjectsInstanceOfInstance() {
        ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
        Assert.assertNotNull(injectionPoint.getPaymentProcessor());
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="da")
    public void testDuplicateBindingsThrowsException() {
        try {
            ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
            injectionPoint.getAnyPaymentProcessor().select(new Annotation[]{new PayByBinding(PayBy.PaymentMethod.CASH){}, new PayByBinding(PayBy.PaymentMethod.CREDIT_CARD){}});
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        Assert.fail();
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="e")
    public void testNonBindingThrowsException() {
        try {
            ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
            injectionPoint.getAnyPaymentProcessor().select(new Annotation[]{new AnnotationLiteral<NonBinding>(){}});
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        Assert.fail();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="ba"), @SpecAssertion(section="programmatic_lookup", id="ca"), @SpecAssertion(section="dynamic_lookup", id="aa"), @SpecAssertion(section="dynamic_lookup", id="ab"), @SpecAssertion(section="dynamic_lookup", id="fa"), @SpecAssertion(section="dynamic_lookup", id="fc")})
    public void testGetMethod() {
        this.getContextualReference(AdvancedPaymentProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).setValue(10);
        Instance<AsynchronousPaymentProcessor> instance = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getPaymentProcessor();
        Assert.assertTrue((boolean)(instance.get() instanceof AdvancedPaymentProcessor));
        Assert.assertEquals((int)((AsynchronousPaymentProcessor)instance.get()).getValue(), (int)10);
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="fba")
    public void testUnsatisfiedDependencyThrowsException() {
        try {
            this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getPaymentProcessor().select(RemotePaymentProcessor.class, new Annotation[0]).get();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(UnsatisfiedResolutionException.class, t));
            return;
        }
        Assert.fail();
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="fbb")
    public void testAmbiguousDependencyThrowsException() {
        try {
            this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getAnyPaymentProcessor().get();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(AmbiguousResolutionException.class, t));
            return;
        }
        Assert.fail();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="aa"), @SpecAssertion(section="dynamic_lookup", id="ba"), @SpecAssertion(section="dynamic_lookup", id="ia"), @SpecAssertion(section="dynamic_lookup", id="ib"), @SpecAssertion(section="annotationliteral_typeliteral", id="a")})
    public void testIteratorMethod() {
        this.getContextualReference(AdvancedPaymentProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).setValue(1);
        this.getContextualReference(RemotePaymentProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).setValue(2);
        Instance<PaymentProcessor> instance = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getAnyPaymentProcessor();
        Iterator iterator1 = instance.select(AsynchronousPaymentProcessor.class, new Annotation[0]).iterator();
        AdvancedPaymentProcessor advanced = null;
        RemotePaymentProcessor remote = null;
        int instances = 0;
        while (iterator1.hasNext()) {
            PaymentProcessor processor = (PaymentProcessor)iterator1.next();
            if (processor instanceof AdvancedPaymentProcessor) {
                advanced = (AdvancedPaymentProcessor)processor;
            } else if (processor instanceof RemotePaymentProcessor) {
                remote = (RemotePaymentProcessor)processor;
            } else {
                throw new RuntimeException("Unexpected instance returned by iterator.");
            }
            ++instances;
        }
        Assert.assertEquals((int)instances, (int)2);
        Assert.assertNotNull(advanced);
        Assert.assertEquals((int)advanced.getValue(), (int)1);
        Assert.assertNotNull(remote);
        Assert.assertEquals((int)remote.getValue(), (int)2);
        Iterator iterator2 = instance.select(RemotePaymentProcessor.class, new Annotation[]{new PayByBinding(PayBy.PaymentMethod.CREDIT_CARD){}}).iterator();
        Assert.assertEquals((int)((RemotePaymentProcessor)iterator2.next()).getValue(), (int)2);
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="ia"), @SpecAssertion(section="dynamic_lookup", id="ib"), @SpecAssertion(section="dynamic_lookup", id="m")})
    public void testAlternatives() {
        Instance<Common> instance = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getCommon();
        Assert.assertFalse((boolean)instance.isAmbiguous());
        Iterator iterator = instance.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof Baz));
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)((Common)instance.get()).ping());
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="l")
    public void testIsUnsatisfied() {
        ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
        Assert.assertFalse((boolean)injectionPoint.getAnyPaymentProcessor().isUnsatisfied());
        Assert.assertTrue((boolean)injectionPoint.getPaymentProcessor().select(RemotePaymentProcessor.class, new Annotation[0]).isUnsatisfied());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="da"), @SpecAssertion(section="dynamic_lookup", id="m")})
    public void testIsAmbiguous() {
        ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)injectionPoint.getAnyPaymentProcessor().isAmbiguous());
        Assert.assertFalse((boolean)injectionPoint.getPaymentProcessor().isAmbiguous());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="e"), @SpecAssertion(section="annotationliteral_typeliteral", id="b"), @SpecAssertion(section="dynamic_lookup", id="ma")})
    public void testNewBean() {
        Instance<String> string = this.getContextualReference(ObtainsNewInstanceBean.class, new Annotation[0]).getString();
        Assert.assertFalse((boolean)string.isAmbiguous());
        Assert.assertFalse((boolean)string.isUnsatisfied());
        Assert.assertNotNull((Object)string.get());
        Assert.assertTrue((boolean)(string.get() instanceof String));
        Instance<Map<String, String>> map = this.getContextualReference(ObtainsNewInstanceBean.class, new Annotation[0]).getMap();
        Assert.assertTrue((boolean)map.isResolvable());
        Map instance = (Map)map.get();
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)(instance instanceof HashMap));
    }

    @Test
    @SpecAssertion(section="new", id="xc")
    public void testNewBeanNotEnabledWithouInjectionPoint() {
        Assert.assertTrue((boolean)this.getContextualReference(ObtainsNewInstanceBean.class, new Annotation[0]).getIae().isUnsatisfied());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="ja"), @SpecAssertion(section="dynamic_lookup", id="jb"), @SpecAssertion(section="dynamic_lookup", id="ma")})
    public void testStream(Instance<Uncommon> uncommonInstance) {
        Assert.assertFalse((boolean)uncommonInstance.isResolvable());
        Stream stream = uncommonInstance.stream();
        Assert.assertEquals((long)stream.count(), (long)2L);
        Assert.assertTrue((boolean)uncommonInstance.stream().filter(p -> p.getClass().equals(Garply.class)).findFirst().isPresent());
        Assert.assertTrue((boolean)uncommonInstance.stream().filter(p -> p.getClass().equals(Corge.class)).findFirst().isPresent());
    }
}

