/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Farm;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.SessionBean;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Sheep;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TagLibraryListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestFilter;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestServlet;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestTagHandler;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class InjectionIntoNonContextualComponentTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(InjectionIntoNonContextualComponentTest.class)).withClasses(Farm.class, ProcessAnnotatedTypeObserver.class, SessionBean.class, Sheep.class, TagLibraryListener.class, TestFilter.class, TestListener.class, TestServlet.class, TestTagHandler.class)).withWebXml("web2.xml")).withWebResource("ManagedBeanTestPage.jsp", "ManagedBeanTestPage.jsp")).withWebResource("TagPage.jsp", "TagPage.jsp")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebResource("TestLibrary.tld", "WEB-INF/TestLibrary.tld")).withDefaultPersistenceXml()).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="ef"), @SpecAssertion(section="fields_initializer_methods_ee", id="ae"), @SpecAssertion(section="fields_initializer_methods_ee", id="bn"), @SpecAssertion(section="injected_fields_ee", id="b")})
    public void testInjectionIntoServlet() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods_ee", id="af"), @SpecAssertion(section="fields_initializer_methods_ee", id="bm"), @SpecAssertion(section="initializer_methods_ee", id="b")})
    public void testServletInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="fields_initializer_methods_ee", id="bo")
    public void testServletInitCalledAfterResourceInjection() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=resource");
        webClient.getPage(this.contextPath + "Test/Servlet?test=ejb");
    }

    @Test(groups={"integration", "persistence"})
    @SpecAssertion(section="fields_initializer_methods_ee", id="bo")
    public void testServletInitCalledAfterPersistenceResourceInjection() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=persistence");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="eg"), @SpecAssertion(section="fields_initializer_methods_ee", id="ag"), @SpecAssertion(section="fields_initializer_methods_ee", id="bq"), @SpecAssertion(section="injected_fields_ee", id="b")})
    public void testInjectionIntoFilter() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods_ee", id="ah"), @SpecAssertion(section="fields_initializer_methods_ee", id="bp"), @SpecAssertion(section="initializer_methods_ee", id="b")})
    public void testFilterInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="fields_initializer_methods_ee", id="br")
    public void testFilterInitCalledAfterResourceInjection() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=resource");
        webClient.getPage(this.contextPath + "TestFilter?test=ejb");
    }

    @Test(groups={"integration", "persistence"})
    @SpecAssertion(section="fields_initializer_methods_ee", id="br")
    public void testFilterInitCalledAfterPersistenceResourceInjection() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=persistence");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="ea"), @SpecAssertion(section="fields_initializer_methods_ee", id="ai"), @SpecAssertion(section="injected_fields_ee", id="b")})
    public void testInjectionIntoServletListener() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/ServletListener?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods_ee", id="aj"), @SpecAssertion(section="initializer_methods_ee", id="b")})
    public void testServletListenerInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/ServletListener?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="eb"), @SpecAssertion(section="fields_initializer_methods_ee", id="am"), @SpecAssertion(section="fields_initializer_methods_ee", id="an"), @SpecAssertion(section="injected_fields_ee", id="b")})
    public void testInjectionIntoTagHandler() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        WebResponse response = webClient.getPage(this.contextPath + "TagPage.jsp").getWebResponse();
        assert (response.getStatusCode() == 200);
        assert (response.getContentAsString().contains("Injection works."));
        assert (response.getContentAsString().contains("Initializer works."));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="ec"), @SpecAssertion(section="fields_initializer_methods_ee", id="as"), @SpecAssertion(section="injected_fields_ee", id="b")})
    public void testInjectionIntoTagLibraryListener() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/TagLibraryListener?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods_ee", id="at"), @SpecAssertion(section="initializer_methods_ee", id="b")})
    public void testTagLibraryListenerInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/TagLibraryListener?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection", id="d"), @SpecAssertion(section="fields_initializer_methods_ee", id="au"), @SpecAssertion(section="fields_initializer_methods_ee", id="av"), @SpecAssertion(section="injected_fields_ee", id="b")})
    public void testInjectionIntoJSFManagedBean() throws Exception {
        WebClient webclient = new WebClient();
        webclient.setThrowExceptionOnFailingStatusCode(true);
        String content = webclient.getPage(this.contextPath + "ManagedBeanTestPage.jsf").getWebResponse().getContentAsString();
        assert (content.contains("Injection works"));
        assert (content.contains("Initializer works"));
    }
}

