/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.filter;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.conversation.filter.OuterFilter;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class ConversationFilterTest
extends AbstractTest {
    private static final String JSESSIONID = "JSESSIONID";
    @ArquillianResource
    protected URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConversationFilterTest.class)).withWebXml((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createFilter().filterName(OuterFilter.class.getSimpleName()).filterClass(OuterFilter.class.getName()).up()).createFilterMapping().filterName(OuterFilter.class.getSimpleName()).urlPattern(new String[]{"/*"}).up()).createFilterMapping().filterName("CDI Conversation Filter").urlPattern(new String[]{"/*"}).up())).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context_ee", id="d")})
    public void testConversationActivation() throws Exception {
        WebClient client = new WebClient();
        client.setThrowExceptionOnFailingStatusCode(true);
        TextPage initPage = (TextPage)client.getPage(this.contextPath + "introspect?mode=" + "init");
        String cid = this.extractCid(initPage.getContent());
        Assert.assertNotNull((Object)cid);
        Assert.assertFalse((boolean)cid.isEmpty());
        TextPage resultPage = (TextPage)client.getPage(this.contextPath + "introspect?mode=" + "inspect" + "&cid=" + cid);
        Assert.assertFalse((boolean)Boolean.valueOf(resultPage.getContent()));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context_ee", id="ua")})
    public void testConversationBusy() throws Exception {
        WebClient client = new WebClient();
        client.setThrowExceptionOnFailingStatusCode(true);
        TextPage initPage = (TextPage)client.getPage(this.contextPath + "introspect?mode=" + "init");
        String cid = this.extractCid(initPage.getContent());
        Assert.assertNotNull((Object)cid);
        Assert.assertFalse((boolean)cid.isEmpty());
        String jsessionid = client.getCookieManager().getCookie(JSESSIONID).getValue();
        Assert.assertNotNull((Object)jsessionid);
        Assert.assertFalse((boolean)jsessionid.isEmpty());
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        WebRequest longTask = new WebRequest("long_task", this.contextPath, cid, jsessionid);
        WebRequest busyRequest = new WebRequest("busy_request", this.contextPath, cid, jsessionid);
        final Future<String> longTaskFuture = executorService.submit(longTask);
        Timer timer = Timer.startNew(100L);
        final Future<String> busyRequestFuture = executorService.submit(busyRequest);
        timer.setSleepInterval(100L).setDelay(10L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return longTaskFuture.isDone() || busyRequestFuture.isDone();
            }
        }).start();
        Assert.assertEquals((String)longTaskFuture.get(), (String)"OK");
        Assert.assertEquals((String)busyRequestFuture.get(), (String)"BusyConversationException");
        executorService.shutdown();
    }

    private String extractCid(String content) {
        String[] tokens = content.split("::");
        if (tokens.length != 2) {
            throw new IllegalArgumentException();
        }
        return tokens[0];
    }

    private class WebRequest
    implements Callable<String> {
        private String mode;
        private URL contextPath;
        private String cid;
        private String jsessionid;

        public WebRequest(String mode, URL contextPath, String cid, String jsessionid) {
            this.mode = mode;
            this.contextPath = contextPath;
            this.cid = cid;
            this.jsessionid = jsessionid;
        }

        @Override
        public String call() throws Exception {
            WebClient client = new WebClient();
            client.setThrowExceptionOnFailingStatusCode(false);
            client.getCookieManager().addCookie(new Cookie(this.contextPath.getHost(), ConversationFilterTest.JSESSIONID, this.jsessionid));
            Page page = client.getPage(this.contextPath + "introspect?mode=" + this.mode + "&cid=" + this.cid);
            if (!(page instanceof TextPage)) {
                return "" + page.getWebResponse().getStatusCode();
            }
            TextPage textPage = (TextPage)page;
            return textPage.getContent();
        }
    }
}

