/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.request.ContextDestructionObserver;
import org.jboss.cdi.tck.tests.context.request.IntrospectFilter;
import org.jboss.cdi.tck.tests.context.request.IntrospectServlet;
import org.jboss.cdi.tck.tests.context.request.TestServletRequestListener;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR2")
public class RequestContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextTest.class)).withWebResource("SimplePage.html", "SimplePage.html")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="request_context_ee", id="aa"), @SpecAssertion(section="request_context_ee", id="ac")})
    public void testRequestScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "test");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="request_context_ee", id="ab"), @SpecAssertion(section="request_context_ee", id="ac")})
    public void testRequestScopeActiveDuringServletFilter() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "SimplePage.html");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="request_context_ee", id="ba"), @SpecAssertion(section="request_context_ee", id="bb"), @SpecAssertion(section="request_context_ee", id="bc")})
    public void testRequestScopeIsDestroyedAfterServletRequest() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "introspect");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "introspect");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertNotEquals((Object)secondRequestResult.getContent().trim(), (Object)firstRequestResult.getContent().trim());
        webClient.getPage(this.contextPath + "introspect?mode=collect");
        ActionSequence correctSequence = new ActionSequence().add(IntrospectServlet.class.getName()).add(IntrospectFilter.class.getName()).add(TestServletRequestListener.class.getName()).add(ContextDestructionObserver.class.getName());
        TextPage destroyRequestResult = (TextPage)webClient.getPage(this.contextPath + "introspect?mode=verify");
        Assert.assertNotNull((Object)destroyRequestResult.getContent());
        Assert.assertEquals((String)destroyRequestResult.getContent(), (String)correctSequence.toString());
    }
}

