/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.builtin.event.complex;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.enterprise.event.Event;
import javax.enterprise.event.NotificationOptions;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.decorators.builtin.event.complex.ObserverMethodComparator;
import org.jboss.cdi.tck.tests.decorators.builtin.event.complex.OrderedEventDeliveryExtension;

@Decorator
public class OrderedEventDeliveryDecorator<T>
implements Event<T>,
Serializable {
    private final Set<Annotation> qualifiers;
    private final BeanManager manager;
    private final ObserverMethodComparator comparator;

    public OrderedEventDeliveryDecorator(Set<Annotation> qualifiers, BeanManager manager, ObserverMethodComparator comparator) {
        this.qualifiers = qualifiers;
        this.manager = manager;
        this.comparator = comparator;
    }

    @Inject
    public OrderedEventDeliveryDecorator(@Delegate Event<T> delegate, InjectionPoint ip, BeanManager manager, OrderedEventDeliveryExtension extension) {
        this.qualifiers = new HashSet<Annotation>(ip.getQualifiers());
        this.manager = manager;
        this.comparator = new ObserverMethodComparator(extension);
    }

    public void fire(T event) {
        Set observers = this.manager.resolveObserverMethods(event, this.qualifiers.toArray(new Annotation[this.qualifiers.size()]));
        ArrayList sortedObservers = new ArrayList(observers);
        Collections.sort(sortedObservers, this.comparator);
        for (ObserverMethod observer : sortedObservers) {
            observer.notify(event);
        }
    }

    public <U extends T> CompletionStage<U> fireAsync(U event) {
        return null;
    }

    public <U extends T> CompletionStage<U> fireAsync(U event, NotificationOptions options) {
        return null;
    }

    public Event<T> select(Annotation ... qualifiers) {
        return new OrderedEventDeliveryDecorator<T>(this.mergeAnnotations(this.qualifiers, qualifiers), this.manager, this.comparator);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return new OrderedEventDeliveryDecorator<T>(this.mergeAnnotations(this.qualifiers, qualifiers), this.manager, this.comparator);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return new OrderedEventDeliveryDecorator<T>(this.mergeAnnotations(this.qualifiers, qualifiers), this.manager, this.comparator);
    }

    private Set<Annotation> mergeAnnotations(Set<Annotation> annotations, Annotation ... additionalAnnotations) {
        HashSet<Annotation> result = new HashSet<Annotation>(annotations);
        for (Annotation annotation : additionalAnnotations) {
            result.add(annotation);
        }
        return result;
    }
}

