/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.bean.AbstractAntelope;
import org.jboss.cdi.tck.tests.definition.bean.Animal;
import org.jboss.cdi.tck.tests.definition.bean.ComplicatedTuna;
import org.jboss.cdi.tck.tests.definition.bean.DeadlyAnimal;
import org.jboss.cdi.tck.tests.definition.bean.DeadlySpider;
import org.jboss.cdi.tck.tests.definition.bean.DependentFinalTuna;
import org.jboss.cdi.tck.tests.definition.bean.FriendlyAntelope;
import org.jboss.cdi.tck.tests.definition.bean.Horse;
import org.jboss.cdi.tck.tests.definition.bean.MyBean;
import org.jboss.cdi.tck.tests.definition.bean.MyGenericBean;
import org.jboss.cdi.tck.tests.definition.bean.MyInterface;
import org.jboss.cdi.tck.tests.definition.bean.MyRawBean;
import org.jboss.cdi.tck.tests.definition.bean.MySuperInterface;
import org.jboss.cdi.tck.tests.definition.bean.RedSnapper;
import org.jboss.cdi.tck.tests.definition.bean.Spider;
import org.jboss.cdi.tck.tests.definition.bean.Tarantula;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class BeanDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="concepts", id="a")
    public void testBeanTypesNonEmpty() {
        Assert.assertEquals((int)this.getBeans(RedSnapper.class, new Annotation[0]).size(), (int)1);
        Assert.assertFalse((boolean)this.getBeans(RedSnapper.class, new Annotation[0]).iterator().next().getTypes().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="concepts", id="b"), @SpecAssertion(section="bean", id="ba")})
    public void testQualifiersNonEmpty() {
        Assert.assertEquals((int)this.getBeans(RedSnapper.class, new Annotation[0]).size(), (int)1);
        Assert.assertFalse((boolean)this.getBeans(RedSnapper.class, new Annotation[0]).iterator().next().getQualifiers().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="concepts", id="c"), @SpecAssertion(section="scopes", id="a"), @SpecAssertion(section="declaring_managed_bean", id="ba"), @SpecAssertion(section="bean", id="ba")})
    public void testHasScopeType() {
        Assert.assertEquals((int)this.getBeans(RedSnapper.class, new Annotation[0]).size(), (int)1);
        Assert.assertEquals((Object)this.getBeans(RedSnapper.class, new Annotation[0]).iterator().next().getScope(), RequestScoped.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="managed_bean_types", id="a"), @SpecAssertion(section="bean_types", id="a"), @SpecAssertion(section="legal_bean_types", id="a"), @SpecAssertion(section="legal_bean_types", id="d"), @SpecAssertion(section="legal_bean_types", id="e"), @SpecAssertion(section="bean_types", id="l"), @SpecAssertion(section="bean", id="ba")})
    public void testBeanTypes() {
        assert (this.getBeans(Tarantula.class, new Annotation[0]).size() == 1);
        Bean<Tarantula> bean = this.getBeans(Tarantula.class, new Annotation[0]).iterator().next();
        Assert.assertEquals((int)bean.getTypes().size(), (int)6);
        Assert.assertTrue((boolean)bean.getTypes().contains(Tarantula.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(Spider.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(Animal.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(Object.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(DeadlySpider.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(DeadlyAnimal.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="managed_bean_types", id="a"), @SpecAssertion(section="bean_types", id="a"), @SpecAssertion(section="bean_types", id="l"), @SpecAssertion(section="bean", id="ba")})
    public void testGenericBeanTypes() {
        Assert.assertEquals((int)this.getBeans(MyRawBean.class, new Annotation[0]).size(), (int)1);
        Bean bean = (Bean)this.getCurrentManager().getBeans(MyGenericBean.class, new Annotation[0]).iterator().next();
        Assert.assertEquals((int)bean.getTypes().size(), (int)5);
        Assert.assertTrue((boolean)BeanDefinitionTest.containsClass(bean.getTypes(), MyGenericBean.class));
        Assert.assertFalse((boolean)bean.getTypes().contains(MyGenericBean.class));
        Assert.assertTrue((boolean)BeanDefinitionTest.containsClass(bean.getTypes(), MyBean.class));
        Assert.assertFalse((boolean)bean.getTypes().contains(MyBean.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(MyInterface.class));
        Assert.assertTrue((boolean)BeanDefinitionTest.containsClass(bean.getTypes(), MySuperInterface.class));
        Assert.assertFalse((boolean)bean.getTypes().contains(MySuperInterface.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="managed_bean_types", id="a"), @SpecAssertion(section="bean_types", id="a"), @SpecAssertion(section="bean_types", id="l"), @SpecAssertion(section="bean", id="ba")})
    public void testRawBeanTypes() {
        Assert.assertEquals((int)this.getBeans(MyRawBean.class, new Annotation[0]).size(), (int)1);
        Bean<MyRawBean> bean = this.getBeans(MyRawBean.class, new Annotation[0]).iterator().next();
        Assert.assertEquals((int)bean.getTypes().size(), (int)5);
        Assert.assertTrue((boolean)bean.getTypes().contains(MyRawBean.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(MyBean.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(MyInterface.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(MySuperInterface.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="typecasting_between_bean_types", id="a")
    public void testBeanClientCanCastBeanInstanceToAnyBeanType() {
        Tarantula tarantula;
        Set<Bean<Tarantula>> beans = this.getBeans(Tarantula.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Bean<Tarantula> bean = beans.iterator().next();
        Tarantula animal = tarantula = (Tarantula)this.getCurrentManager().getContext(bean.getScope()).get(bean);
        Tarantula obj = tarantula;
        Tarantula deadlySpider = tarantula;
        Tarantula deadlyAnimal = tarantula;
    }

    @Test
    @SpecAssertion(section="legal_bean_types", id="c")
    public void testAbstractApiType() {
        Set<Bean<FriendlyAntelope>> beans = this.getBeans(FriendlyAntelope.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Bean<FriendlyAntelope> bean = beans.iterator().next();
        Assert.assertEquals((int)bean.getTypes().size(), (int)4);
        Assert.assertTrue((boolean)bean.getTypes().contains(FriendlyAntelope.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(AbstractAntelope.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(Animal.class));
        Assert.assertTrue((boolean)bean.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="legal_bean_types", id="d")
    public void testFinalApiType() {
        Assert.assertFalse((boolean)this.getBeans(DependentFinalTuna.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_managed_bean", id="bd"), @SpecAssertion(section="bean", id="ba")})
    public void testMultipleStereotypes() {
        Bean<ComplicatedTuna> tunaBean = this.getBeans(ComplicatedTuna.class, new Annotation[0]).iterator().next();
        Assert.assertEquals((Object)tunaBean.getScope(), RequestScoped.class);
        Assert.assertEquals((String)tunaBean.getName(), (String)"complicatedTuna");
    }

    @Test
    @SpecAssertion(section="declaring_managed_bean", id="c")
    public void testBeanExtendsAnotherBean() {
        Assert.assertFalse((boolean)this.getBeans(Spider.class, new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.getBeans(Tarantula.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertion(section="bean", id="bb")
    public void testBeanClassOnSimpleBean() {
        Set<Bean<Horse>> beans = this.getBeans(Horse.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertEquals((Object)beans.iterator().next().getBeanClass(), Horse.class);
    }

    private static boolean containsClass(Set<Type> types, Class<?> clazz) {
        for (Type type : types) {
            if (type instanceof Class && ((Class)type).equals(clazz)) {
                return true;
            }
            if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

