/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.priority.transactional;

import java.util.List;
import javax.enterprise.event.TransactionPhase;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.OnlineAccountService;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.PhisherAccountTransactionObserver;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.ReceiverAccountTransactionObserver;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.SenderAccountTransactionObserver;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "persistence"})
@SpecVersion(spec="cdi", version="2.0-EDR2")
public class TransactionalPriorityObserverTest
extends AbstractTest {
    private static final SimpleLogger logger = new SimpleLogger(TransactionalPriorityObserverTest.class);
    @Inject
    OnlineAccountService accountService;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(TransactionalPriorityObserverTest.class)).withDefaultPersistenceXml()).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="transactional_observer_methods", id="a"), @SpecAssertion(section="transactional_observer_methods", id="b"), @SpecAssertion(section="transactional_observer_methods", id="c"), @SpecAssertion(section="transactional_observer_methods", id="d"), @SpecAssertion(section="transactional_observer_methods", id="e"), @SpecAssertion(section="transactional_observer_methods", id="gaa"), @SpecAssertion(section="observer_notification", id="b")})
    public void testSucessfulTransaction() throws Exception {
        logger.log("testSucessfulTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawSuccesTransaction(1);
        List<String> phases = ActionSequence.getSequenceData();
        Assert.assertEquals((int)phases.size(), (int)13);
        Assert.assertEquals((String)phases.get(0), (String)(TransactionPhase.IN_PROGRESS.name() + "." + SenderAccountTransactionObserver.class.getSimpleName()));
        Assert.assertEquals((String)phases.get(1), (String)(TransactionPhase.IN_PROGRESS.name() + "." + ReceiverAccountTransactionObserver.class.getSimpleName()));
        Assert.assertEquals((String)phases.get(2), (String)(TransactionPhase.IN_PROGRESS.name() + "." + PhisherAccountTransactionObserver.class.getSimpleName()));
        Assert.assertEquals((String)phases.get(3), (String)"checkpoint");
        Assert.assertEquals((String)phases.get(4), (String)(TransactionPhase.BEFORE_COMPLETION.name() + "." + ReceiverAccountTransactionObserver.class.getSimpleName()));
        Assert.assertEquals((String)phases.get(5), (String)(TransactionPhase.BEFORE_COMPLETION.name() + "." + SenderAccountTransactionObserver.class.getSimpleName()));
        Assert.assertEquals((String)phases.get(6), (String)(TransactionPhase.BEFORE_COMPLETION.name() + "." + PhisherAccountTransactionObserver.class.getSimpleName()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_SUCCESS.name() + "." + ReceiverAccountTransactionObserver.class.getSimpleName()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_SUCCESS.name() + "." + SenderAccountTransactionObserver.class.getSimpleName()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_SUCCESS.name() + "." + PhisherAccountTransactionObserver.class.getSimpleName()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_COMPLETION.name() + "." + ReceiverAccountTransactionObserver.class.getSimpleName()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_COMPLETION.name() + "." + SenderAccountTransactionObserver.class.getSimpleName()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_COMPLETION.name() + "." + PhisherAccountTransactionObserver.class.getSimpleName()));
    }
}

