/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional.custom;

import java.lang.annotation.Annotation;
import javax.enterprise.event.TransactionPhase;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.transactional.custom.Giraffe;
import org.jboss.cdi.tck.tests.event.observer.transactional.custom.GiraffeService;
import org.jboss.cdi.tck.tests.event.observer.transactional.custom.ObserverExtension;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class CustomTransactionalObserverTest
extends AbstractTest {
    @Inject
    private GiraffeService giraffeService;
    @Inject
    private ObserverExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CustomTransactionalObserverTest.class)).withExtension(ObserverExtension.class)).withDefaultPersistenceXml()).build();
    }

    @Test(groups={"integration", "persistence"})
    @SpecAssertions(value={@SpecAssertion(section="observer_notification", id="fa"), @SpecAssertion(section="observer_notification", id="fb")})
    public void testCustomTransactionalObserver() throws Exception {
        ActionSequence.reset();
        Assert.assertEquals((int)this.getCurrentManager().resolveObserverMethods((Object)new Giraffe(), new Annotation[0]).size(), (int)3);
        this.giraffeService.feed();
        Assert.assertNotNull(this.extension.getAnyGiraffeObserver().getReceivedPayload());
        Assert.assertEquals(Giraffe.class, ((Giraffe)this.extension.getAnyGiraffeObserver().getReceivedPayload().getEvent()).getClass());
        Assert.assertNotNull((Object)this.extension.getAnyGiraffeObserver().getReceivedPayload().getMetadata());
        Assert.assertTrue((boolean)this.extension.getAnyGiraffeObserver().isTransactionPhaseCalled());
        ActionSequence.getSequence().beginsWith("checkpoint", TransactionPhase.BEFORE_COMPLETION.toString());
        ActionSequence.getSequence().assertDataContainsAll(TransactionPhase.AFTER_SUCCESS.toString(), TransactionPhase.AFTER_COMPLETION.toString());
    }
}

