/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.New;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.AnimalDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.Cat;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.Dog;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.Fast;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.Hound;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.InjectingBean;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.Lazy;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionPoint.modify.ModifyingExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-EDR2")
public class InjectionPointOverridingTest
extends AbstractTest {
    @Inject
    InjectingBean bean;
    @Inject
    @Fast
    Hound hound;
    @Inject
    @Lazy
    Dog dog;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionPointOverridingTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateDecorators().clazz(new String[]{AnimalDecorator.class.getName()}).up())).withExtension(ModifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="bb"), @SpecAssertion(section="process_injection_point", id="c")})
    public void testOverridingFieldInjectionPoint() {
        Assert.assertTrue((boolean)(this.bean.getDog() instanceof Hound));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="bb"), @SpecAssertion(section="process_injection_point", id="c")})
    public void testDelegateInjectionPoint() {
        Assert.assertNotNull((Object)this.hound);
        Assert.assertTrue((boolean)this.hound.decorated());
        Assert.assertNotNull((Object)this.dog);
        Assert.assertTrue((boolean)this.dog.decorated());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="a"), @SpecAssertion(section="process_injection_point", id="bb"), @SpecAssertion(section="process_injection_point", id="c")})
    public void testNewInjectionPointDiscovered() {
        Assert.assertEquals((int)this.getBeans(Cat.class, new Annotation[]{New.Literal.INSTANCE}).size(), (int)1);
        Assert.assertNotNull((Object)this.bean.getCat());
        Assert.assertNotNull(this.bean.getCat().getBean());
        Assert.assertEquals((Object)this.bean.getCat().getBean().getScope(), Dependent.class);
        Assert.assertNull((Object)this.bean.getCat().getBean().getName());
    }
}

