/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.async;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class ApplicationContextAsyncListenerTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ApplicationContextAsyncListenerTest.class)).build();
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context_ee", id="ae")
    public void testApplicationContextActiveOnComplete() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("complete"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onComplete: true"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context_ee", id="ae")
    public void testApplicationContextActiveOnTimeout() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        webClient.getPage(this.getPath("timeout"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onTimeout: true"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context_ee", id="ae")
    public void testApplicationContextActiveOnError() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        webClient.getPage(this.getPath("error"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onError: true"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context_ee", id="ae")
    public void testApplicationContextActiveOnStartAsync() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("loop"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onStartAsync: true"));
        Assert.assertTrue((boolean)results.getContent().contains("onComplete: true"));
    }

    private String getPath(String test) {
        return this.contextPath + "AsyncServlet?test=" + test;
    }
}

