/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.managed.dependent;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.IllegalProductException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.managed.dependent.British;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.managed.dependent.ConstructorInjectionCorralBroken;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.managed.dependent.FieldInjectionCorralBroken;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.managed.dependent.Herd;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.managed.dependent.Ranch;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.method.managed.dependent.SetterInjectionCorralBroken;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class ManagedBeanWithIllegalDependencyTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ManagedBeanWithIllegalDependencyTest.class)).build();
    }

    @Test
    @SpecAssertion(section="passivation_validation", id="fab")
    public void testFieldInjectionPointRequiringPassivationCapableDependency() {
        this.verify(FieldInjectionCorralBroken.class, new Annotation[0]);
    }

    @Test
    @SpecAssertion(section="passivation_validation", id="fab")
    public void testSetterInjectionPointRequiringPassivationCapableDependency() {
        this.verify(SetterInjectionCorralBroken.class, new Annotation[0]);
    }

    @Test
    @SpecAssertion(section="passivation_validation", id="fab")
    public void testConstructorInjectionPointRequiringPassivationCapableDependency() {
        this.verify(ConstructorInjectionCorralBroken.class, new Annotation[0]);
    }

    @Test
    @SpecAssertion(section="passivation_validation", id="fab")
    public void testProducerMethodParamInjectionPointRequiringPassivationCapableDependency() {
        this.verify(Herd.class, British.BritishLiteral.INSTANCE);
    }

    private void verify(Class<? extends Ranch> clazz, Annotation ... annotations) {
        try {
            this.getContextualReference(clazz, annotations).ping();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalProductException.class, t));
            return;
        }
        Assert.fail();
    }
}

