/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.dependency.sessionbean;

import java.io.IOException;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.dependency.sessionbean.Chef;
import org.jboss.cdi.tck.tests.context.passivating.dependency.sessionbean.Spoon;
import org.jboss.cdi.tck.tests.context.passivating.dependency.sessionbean.Worker;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class SessionBeanPassivationDependencyTest
extends AbstractTest {
    @Inject
    Worker worker;
    @Inject
    Chef chef;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionBeanPassivationDependencyTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency_ee", id="ab")})
    public void testSingleton() throws IOException, ClassNotFoundException {
        Assert.assertNotNull((Object)this.worker);
        Assert.assertNotNull((Object)this.worker.getHammer());
        String workerId = this.worker.getId();
        String hammerId = this.worker.getHammer().getId();
        byte[] serializedWorker = this.passivate(this.worker);
        Worker workerCopy = (Worker)this.activate(serializedWorker);
        Assert.assertNotNull((Object)workerCopy);
        Assert.assertNotNull((Object)workerCopy.getHammer());
        Assert.assertEquals((String)workerCopy.getId(), (String)workerId);
        Assert.assertEquals((String)workerCopy.getHammer().getId(), (String)hammerId);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency_ee", id="aa")})
    public void testStateless() throws IOException, ClassNotFoundException {
        Assert.assertNotNull((Object)this.chef);
        Assert.assertNotNull((Object)this.chef.getSpoon());
        String chefId = this.chef.getId();
        byte[] serializedChef = this.passivate(this.chef);
        Chef chefCopy = (Chef)this.activate(serializedChef);
        Assert.assertNotNull((Object)chefCopy);
        Assert.assertNotNull((Object)chefCopy.getSpoon());
        Assert.assertEquals((String)chefCopy.getId(), (String)chefId);
        Assert.assertEquals((String)chefCopy.getSpoon().getId(), (String)Spoon.class.getName());
    }
}

