/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.shutdown;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import java.net.URLEncoder;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeforeShutdown;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.api.InSequence;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.deployment.shutdown.Bar;
import org.jboss.cdi.tck.tests.deployment.shutdown.Baz;
import org.jboss.cdi.tck.tests.deployment.shutdown.ContextDestructionObserver;
import org.jboss.cdi.tck.tests.deployment.shutdown.Foo;
import org.jboss.cdi.tck.tests.deployment.shutdown.InfoClient;
import org.jboss.cdi.tck.tests.deployment.shutdown.InfoServlet;
import org.jboss.cdi.tck.tests.deployment.shutdown.InitServlet;
import org.jboss.cdi.tck.tests.deployment.shutdown.LifecycleMonitoringExtension;
import org.jboss.cdi.tck.tests.deployment.shutdown.Qux;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.cdi.tck.util.TransformationUtils;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class ApplicationShutdownLifecycleTest
extends AbstractTest {
    private static final String FOO = "foo";
    private static final String INFO = "info";
    @ArquillianResource
    Deployer deployer;

    @Deployment(name="foo", managed=false, testable=false)
    public static WebArchive createFooTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(ContextDestructionObserver.class, LifecycleMonitoringExtension.class, SimpleLogger.class, InitServlet.class, InfoClient.class, Foo.class, Bar.class, Baz.class, Qux.class)).withExtension(LifecycleMonitoringExtension.class)).build();
    }

    @Deployment(name="info", managed=false, testable=false)
    public static WebArchive createBarTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(InfoServlet.class, ActionSequence.class, TransformationUtils.class, TransformationUtils.Function.class)).build();
    }

    @Test
    @InSequence(value=1)
    public void deployArchives() {
        this.deployer.deploy(FOO);
        this.deployer.deploy(INFO);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="shutdown", id="a"), @SpecAssertion(section="shutdown", id="b"), @SpecAssertion(section="request_context_ee", id="ja"), @SpecAssertion(section="application_context_ee", id="ga"), @SpecAssertion(section="before_shutdown", id="a")})
    public void testShutdown(@ArquillianResource @OperateOnDeployment(value="foo") URL fooContext, @ArquillianResource @OperateOnDeployment(value="info") URL infoContext) throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(fooContext + "init?url=" + URLEncoder.encode(infoContext.toExternalForm(), "UTF-8"));
        this.deployer.undeploy(FOO);
        TextPage info = (TextPage)webClient.getPage(infoContext + "info?action=get");
        ActionSequence actual = ActionSequence.buildFromCsvData(info.getContent());
        Assert.assertTrue((boolean)actual.endsWith(BeforeShutdown.class.getName()));
        actual.assertDataContainsAll(RequestScoped.class.getName(), SessionScoped.class.getName(), ApplicationScoped.class.getName(), ConversationScoped.class.getName(), Foo.class.getName(), Bar.class.getName(), Baz.class.getName(), Qux.class.getName());
        this.deployer.undeploy(INFO);
    }
}

