/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.trimmed.enteprise;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.deployment.trimmed.enteprise.Bike;
import org.jboss.cdi.tck.tests.deployment.trimmed.enteprise.MotorizedVehicle;
import org.jboss.cdi.tck.tests.deployment.trimmed.enteprise.TestExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class EnterpriseTrimmedBeanArchiveTest
extends AbstractTest {
    @Inject
    TestExtension extension;
    @Inject
    Instance<Bike> bikeInstance;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseTrimmedBeanArchiveTest.class)).withExtension(TestExtension.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertion(section="trimmed_bean_archive_ee", id="a")
    public void testDiscoveredBean() {
        Assert.assertEquals((int)this.extension.getVehiclePBAinvocations().get(), (int)1);
        Bean<MotorizedVehicle> vehicleBean = this.getUniqueBean(MotorizedVehicle.class, new Annotation[0]);
        CreationalContext cc = this.getCurrentManager().createCreationalContext(vehicleBean);
        MotorizedVehicle vehicle = (MotorizedVehicle)this.getCurrentManager().getReference(vehicleBean, MotorizedVehicle.class, cc);
        Assert.assertEquals((String)vehicle.start(), (String)"car started");
        Assert.assertEquals((int)this.extension.getBikePBAinvocations().get(), (int)1);
        Assert.assertTrue((boolean)this.bikeInstance.isResolvable());
        Assert.assertTrue((boolean)((Bike)this.bikeInstance.get()).ping());
    }
}

