/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.priority;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.priority.MoonActivity;
import org.jboss.cdi.tck.tests.event.observer.priority.MoonObservers;
import org.jboss.cdi.tck.tests.event.observer.priority.Moonrise;
import org.jboss.cdi.tck.tests.event.observer.priority.ObserverExtension;
import org.jboss.cdi.tck.tests.event.observer.priority.Sunrise;
import org.jboss.cdi.tck.tests.event.observer.priority.SunriseObservers;
import org.jboss.cdi.tck.tests.event.observer.priority.Sunset;
import org.jboss.cdi.tck.tests.event.observer.priority.SunsetObservers;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class EventObserverOrderingTest
extends AbstractTest {
    @Inject
    private Event<Sunset> sunset;
    @Inject
    private Event<Sunrise> sunrise;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(Sunrise.class)).withExtension(ObserverExtension.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="observer_ordering", id="a"), @SpecAssertion(section="observer_method", id="ea")})
    public void testDefaultPriority(ObserverExtension observerExtension) {
        Assert.assertEquals((int)observerExtension.getObserverMethodPriority("Observer2.observeMoon"), (int)2500);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="observer_method", id="ea")})
    public void testProcessObserverMethodPriority(ObserverExtension observerExtension) {
        Assert.assertEquals((int)observerExtension.getObserverMethodPriority("Observer3.observeMoon"), (int)2900);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_ordering", id="b")})
    public void testFireEventLowerPriorityBeforeDefaultPriority() {
        ActionSequence.reset();
        this.sunrise.fire((Object)new Sunrise());
        Assert.assertEquals((int)ActionSequence.getSequenceSize(), (int)3);
        Assert.assertTrue((boolean)ActionSequence.getSequence().beginsWith(SunriseObservers.AsianObserver.class.getName()));
        ActionSequence.assertSequenceDataContainsAll(SunriseObservers.GermanObserver.class.getName(), SunriseObservers.ItalianObserver.class.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_ordering", id="b")})
    public void testResolveObserversLowerPriorityBeforeDefaultPriority() {
        Set observerMethods = this.getCurrentManager().resolveObserverMethods((Object)new Sunrise(), new Annotation[0]);
        Assert.assertEquals((int)3, (int)observerMethods.size());
        Assert.assertEquals((Object)((ObserverMethod)observerMethods.iterator().next()).getBeanClass(), SunriseObservers.AsianObserver.class);
        List classes = observerMethods.stream().map(ObserverMethod::getBeanClass).collect(Collectors.toList());
        Assert.assertTrue((boolean)classes.contains(SunriseObservers.GermanObserver.class));
        Assert.assertTrue((boolean)classes.contains(SunriseObservers.ItalianObserver.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_ordering", id="b")})
    public void testFireEventToMultipleObserversWithPriority() {
        ActionSequence.reset();
        this.sunset.fire((Object)new Sunset());
        Assert.assertEquals((int)ActionSequence.getSequenceSize(), (int)3);
        Assert.assertTrue((boolean)ActionSequence.getSequence().beginsWith(SunsetObservers.AsianObserver.class.getName(), SunsetObservers.EuropeanObserver.class.getName(), SunsetObservers.AmericanObserver.class.getName()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_ordering", id="b")})
    public void testPrioritizedEventSubclass() {
        ActionSequence.reset();
        this.getCurrentManager().fireEvent((Object)new Moonrise(), new Annotation[0]);
        Assert.assertEquals((int)ActionSequence.getSequenceSize(), (int)4);
        ActionSequence.assertSequenceDataEquals(MoonObservers.Observer1.class.getName(), MoonObservers.Observer2.class.getName(), MoonObservers.Observer3.class.getName(), MoonObservers.Observer4.class.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_ordering", id="b")})
    public void testPrioritizedEventBaseclass() {
        ActionSequence.reset();
        this.getCurrentManager().fireEvent((Object)new MoonActivity(), new Annotation[0]);
        Assert.assertEquals((int)ActionSequence.getSequenceSize(), (int)2);
        ActionSequence.assertSequenceDataEquals(MoonObservers.Observer1.class.getName(), MoonObservers.Observer3.class.getName());
    }
}

