/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Context;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.Cage;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.Cockatoo;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.SuperContext;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.SuperScoped;
import org.jboss.cdi.tck.tests.extensions.afterBeanDiscovery.Talk;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class AfterBeanDiscoveryTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AfterBeanDiscoveryTest.class)).withExtension(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_bean_discovery", id="db")})
    public void testBeanIsAdded() {
        Assert.assertEquals((int)1, (int)this.getBeans(Cockatoo.class, new Annotation[0]).size());
        Assert.assertEquals((String)"Billy", (String)this.getContextualReference(Cockatoo.class, new Annotation[0]).getName());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="ea")})
    public void testCustomDependentBeanInjectionPointIsAvailable(Cage cage) {
        Assert.assertNotNull((Object)cage);
        Assert.assertNotNull((Object)cage.getCockatoo());
        Assert.assertNotNull((Object)cage.getCockatoo().getInjectionPoint());
        Assert.assertEquals((Object)cage.getCockatoo().getInjectionPoint().getBean().getBeanClass(), Cage.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_bean_discovery", id="da"), @SpecAssertion(section="process_bean", id="eca")})
    public void testProcessBeanIsFired() {
        Assert.assertEquals((int)((AfterBeanDiscoveryObserver)this.getCurrentManager().getExtension(AfterBeanDiscoveryObserver.class)).getCockatooPBObservedCount().get(), (int)1);
        Assert.assertEquals((int)((AfterBeanDiscoveryObserver)this.getCurrentManager().getExtension(AfterBeanDiscoveryObserver.class)).getCockatooPSBObservedCount().get(), (int)1);
    }

    @Test
    @SpecAssertion(section="after_bean_discovery", id="ea")
    public void testProcessObserverMethodFiredWhileAddingObserverMethod() {
        Assert.assertEquals((int)((AfterBeanDiscoveryObserver)this.getCurrentManager().getExtension(AfterBeanDiscoveryObserver.class)).getTalkPOMObservedCount().get(), (int)1);
        Assert.assertEquals((int)((AfterBeanDiscoveryObserver)this.getCurrentManager().getExtension(AfterBeanDiscoveryObserver.class)).getTalkPSOMObservedCount().get(), (int)1);
    }

    @Test
    @SpecAssertion(section="after_bean_discovery", id="eb")
    public void testObserverMethodRegistered() {
        this.getCurrentManager().fireEvent((Object)new Talk("Hello"), new Annotation[0]);
        Assert.assertTrue((boolean)AfterBeanDiscoveryObserver.addedObserverMethod.isObserved());
    }

    @Test
    @SpecAssertion(section="after_bean_discovery", id="f")
    public void testAddContext() {
        Context context = this.getCurrentManager().getContext(SuperScoped.class);
        Assert.assertNotNull((Object)context);
        Assert.assertTrue((boolean)context.isActive());
        Assert.assertTrue((boolean)(context instanceof SuperContext));
    }
}

