/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.broken;

import javax.enterprise.inject.spi.Unmanaged;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.broken.House;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class UnamangedInstanceIllegalStatesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(UnamangedInstanceIllegalStatesTest.class)).build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="c")
    public void produceCalledOnAlreadyProducedInstance() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        unmanagedHouseInstance.produce().get();
        unmanagedHouseInstance.produce();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="d")
    public void produceCalledOnAlreadyDisposedInstance() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        House house = (House)unmanagedHouseInstance.produce().get();
        house.build();
        unmanagedHouseInstance.dispose();
        unmanagedHouseInstance.produce();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="e")
    public void injectCallBeforeProduce() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        unmanagedHouseInstance.inject();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="f")
    public void injectCalledOnAlreadyDisposedInstance() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        House house = (House)unmanagedHouseInstance.produce().get();
        house.build();
        unmanagedHouseInstance.dispose();
        unmanagedHouseInstance.inject();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="g")
    public void posConstructCallBeforeProduce() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        unmanagedHouseInstance.postConstruct();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="h")
    public void postConstructCalledOnAlreadyDisposedInstance() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        House house = (House)unmanagedHouseInstance.produce().get();
        house.build();
        unmanagedHouseInstance.dispose();
        unmanagedHouseInstance.postConstruct();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="i")
    public void preDestroyCallBeforeProduce() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        unmanagedHouseInstance.preDestroy();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="j")
    public void preDeStroyCalledOnAlreadyDisposedInstance() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        House house = (House)unmanagedHouseInstance.produce().get();
        house.build();
        unmanagedHouseInstance.dispose();
        unmanagedHouseInstance.preDestroy();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="k")
    public void disposeCallBeforeProduce() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        unmanagedHouseInstance.dispose();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="bm_obtain_unmanaged_instance", id="l")
    public void disposeCalledOnAlreadyDisposedInstance() {
        Unmanaged.UnmanagedInstance<House> unmanagedHouseInstance = this.createUnmanagedInstance();
        House house = (House)unmanagedHouseInstance.produce().get();
        house.build();
        unmanagedHouseInstance.dispose();
        unmanagedHouseInstance.dispose();
    }

    private Unmanaged.UnmanagedInstance<House> createUnmanagedInstance() {
        Unmanaged unmanagedHouse = new Unmanaged(this.getCurrentManager(), House.class);
        Unmanaged.UnmanagedInstance unmanagedHouseInstance = unmanagedHouse.newInstance();
        return unmanagedHouseInstance;
    }
}

