/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.DisposesLiteral;
import org.jboss.cdi.tck.literals.ProducesLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.AnimalShelter;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Cat;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Cats;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Countryside;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Dog;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.DogDependenciesProducer;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Dogs;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Feed;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Room;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-PFD")
public class AnnotatedTypeConfiguratorTest
extends AbstractTest {
    @Inject
    Instance<Countryside> countrysideInstance;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AnnotatedTypeConfiguratorTest.class)).withClasses(ProducesLiteral.class, DisposesLiteral.class)).withExtensions(ProcessAnnotatedTypeObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotated_type_configurator", id="bd"), @SpecAssertion(section="annotated_type_configurator", id="bg"), @SpecAssertion(section="annotated_type_configurator", id="bi"), @SpecAssertion(section="annotated_type_configurator", id="bj"), @SpecAssertion(section="annotated_constructor_configurator", id="b"), @SpecAssertion(section="annotated_method_configurator", id="b"), @SpecAssertion(section="annotated_constructor_configurator", id="f"), @SpecAssertion(section="annotated_field_configurator", id="b"), @SpecAssertion(section="annotated_parameter_configurator", id="b")})
    public void addMethodsOfAnnotationTypecConfigurator() {
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Annotation[0]);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(dogBean);
        Dog dog = (Dog)dogBean.create(creationalContext);
        Assert.assertNotNull(dogBean);
        Assert.assertEquals((Object)dogBean.getScope(), RequestScoped.class);
        Assert.assertNotNull((Object)dog.getFeed());
        Assert.assertEquals((String)dog.getName(), (String)DogDependenciesProducer.dogName);
        List dogsInjectionPoints = dogBean.getInjectionPoints().stream().filter(injectionPoint -> injectionPoint.getQualifiers().contains(new Dogs.DogsLiteral())).collect(Collectors.toList());
        Assert.assertEquals((int)dogsInjectionPoints.size(), (int)2);
        Optional<InjectionPoint> feedIpOptional = dogsInjectionPoints.stream().filter(injectionPoint -> injectionPoint.getType().equals(Feed.class)).findFirst();
        Assert.assertTrue((boolean)feedIpOptional.isPresent());
        dogBean.destroy((Object)dog, creationalContext);
        Assert.assertTrue((boolean)DogDependenciesProducer.disposerCalled.get());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotated_type_configurator", id="be"), @SpecAssertion(section="annotated_type_configurator", id="bh"), @SpecAssertion(section="annotated_type_configurator", id="bj"), @SpecAssertion(section="annotated_type_configurator", id="bl"), @SpecAssertion(section="annotated_method_configurator", id="c"), @SpecAssertion(section="annotated_constructor_configurator", id="c"), @SpecAssertion(section="annotated_method_configurator", id="f"), @SpecAssertion(section="annotated_field_configurator", id="c"), @SpecAssertion(section="annotated_parameter_configurator", id="c")})
    public void removeMethodsOfAnnotationTypeConfigurator() {
        Bean<Cat> catBean = this.getUniqueBean(Cat.class, new Annotation[0]);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(catBean);
        Cat cat = (Cat)catBean.create(creationalContext);
        Assert.assertNotNull(catBean);
        Assert.assertEquals((Object)catBean.getScope(), Dependent.class);
        Assert.assertNull((Object)cat.getFeed());
        Set<Bean<Feed>> catFeedBeans = this.getBeans(Feed.class, Cats.CatsLiteral.INSTANCE);
        Assert.assertEquals((int)catFeedBeans.size(), (int)0);
        this.getCurrentManager().fireEvent((Object)new Feed(), new Annotation[0]);
        Assert.assertFalse((boolean)cat.isFeedObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotated_type_configurator", id="bc"), @SpecAssertion(section="annotated_method_configurator", id="a"), @SpecAssertion(section="annotated_field_configurator", id="a"), @SpecAssertion(section="annotated_constructor_configurator", id="a"), @SpecAssertion(section="annotated_parameter_configurator", id="a")})
    public void annotatedTypesAndMemebersEqual() {
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.annotatedTypesEqual.get());
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.annotatedMethodEqual.get());
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.annotatedFieldEqual.get());
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.annotatedConstructorEqual.get());
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.annotatedParameterEqual.get());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotated_type_configurator", id="bf"), @SpecAssertion(section="annotated_type_configurator", id="bk"), @SpecAssertion(section="annotated_constructor_configurator", id="d"), @SpecAssertion(section="annotated_method_configurator", id="d"), @SpecAssertion(section="annotated_parameter_configurator", id="d"), @SpecAssertion(section="annotated_method_configurator", id="e"), @SpecAssertion(section="annotated_field_configurator", id="d")})
    public void annotationsRemovedFromAnimalShelter() {
        Bean<AnimalShelter> animalShelterBean = this.getUniqueBean(AnimalShelter.class, new Annotation[0]);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(animalShelterBean);
        AnimalShelter animalShelter = (AnimalShelter)animalShelterBean.create(creationalContext);
        this.getCurrentManager().fireEvent((Object)new Room(), new Annotation[]{Cats.CatsLiteral.INSTANCE, Any.Literal.INSTANCE});
        Assert.assertNotNull(animalShelterBean);
        Assert.assertEquals((String)animalShelterBean.getName(), null);
        Assert.assertEquals((Object)animalShelterBean.getScope(), Dependent.class);
        Assert.assertFalse((boolean)animalShelter.isPostConstructCalled());
        Assert.assertFalse((boolean)animalShelter.isRoomObserved());
        Assert.assertNull((Object)animalShelter.getCat());
    }

    @Test
    @SpecAssertion(section="process_annotated_type", id="bba")
    public void configuratorInitializedWithOriginalAT() {
        AnnotatedType<Cat> catAT = ((ProcessAnnotatedTypeObserver)this.getCurrentManager().getExtension(ProcessAnnotatedTypeObserver.class)).getOriginalCatAT();
        Assert.assertTrue((boolean)catAT.isAnnotationPresent(RequestScoped.class));
        AnnotatedConstructor annotatedConstructor = catAT.getConstructors().stream().filter(catAnnotatedConstructor -> catAnnotatedConstructor.getParameters().size() == 1).findFirst().get();
        Assert.assertTrue((boolean)((AnnotatedParameter)annotatedConstructor.getParameters().iterator().next()).isAnnotationPresent(Cats.class));
        Assert.assertTrue((boolean)annotatedConstructor.isAnnotationPresent(Inject.class));
    }

    @Test
    @SpecAssertion(section="annotated_constructor_configurator", id="e")
    public void configureAndTestConstructorAnnotatedParams() {
        Assert.assertFalse((boolean)this.countrysideInstance.isUnsatisfied());
        Countryside countryside = (Countryside)this.countrysideInstance.get();
        Assert.assertEquals((String)countryside.getWildDog().getName(), (String)"wild dog");
        Assert.assertEquals((String)countryside.getWildCat().getName(), (String)"wild cat");
    }
}

