/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.AirPlane;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.Car;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.Driving;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.Engine;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.Flying;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.Helicopter;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.ProcessInjectionPointObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.injectionPoint.Ship;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-PFD")
public class InjectionPointConfiguratorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionPointConfiguratorTest.class)).withExtension(ProcessInjectionPointObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point_configurator", id="ba"), @SpecAssertion(section="injection_point_configurator", id="bb")})
    public void changeTypeAndAddQualifier() {
        Bean<AirPlane> airPlaneBean = this.getUniqueBean(AirPlane.class, new Annotation[0]);
        Assert.assertEquals((int)airPlaneBean.getInjectionPoints().size(), (int)1);
        InjectionPoint engineIP = (InjectionPoint)airPlaneBean.getInjectionPoints().iterator().next();
        Assert.assertNotNull((Object)engineIP);
        Assert.assertEquals((Object)engineIP.getType(), Engine.class);
        Assert.assertEquals((Set)engineIP.getQualifiers(), Collections.singleton(Flying.FlyingLiteral.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point_configurator", id="bc"), @SpecAssertion(section="injection_point_configurator", id="be")})
    public void replaceQualifiersAndDelegate() {
        List vehicleDecorators = this.getCurrentManager().resolveDecorators(Collections.singleton(Car.class), new Annotation[]{Driving.DrivingLiteral.INSTANCE});
        Assert.assertEquals((int)vehicleDecorators.size(), (int)1);
        Decorator vehicleDecorator = (Decorator)vehicleDecorators.get(0);
        Assert.assertEquals((int)vehicleDecorator.getInjectionPoints().size(), (int)1);
        InjectionPoint vehicleIp = (InjectionPoint)vehicleDecorator.getInjectionPoints().iterator().next();
        Assert.assertEquals((boolean)vehicleIp.isDelegate(), (boolean)true);
        Assert.assertEquals((Set)vehicleIp.getQualifiers(), Collections.singleton(Driving.DrivingLiteral.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point_configurator", id="bf")})
    public void readFromFieldAndCheckTransientField() {
        Bean<Ship> shipBean = this.getUniqueBean(Ship.class, new Annotation[0]);
        Assert.assertEquals((int)shipBean.getInjectionPoints().size(), (int)1);
        InjectionPoint engineIP = (InjectionPoint)shipBean.getInjectionPoints().iterator().next();
        Assert.assertEquals((boolean)engineIP.isTransient(), (boolean)true);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="bba")})
    public void configuratorInitializedWithOriginalInjectionPoint() {
        InjectionPoint configuredOne = (InjectionPoint)this.getUniqueBean(Helicopter.class, new Annotation[0]).getInjectionPoints().iterator().next();
        InjectionPoint originalOne = ((ProcessInjectionPointObserver)this.getCurrentManager().getExtension(ProcessInjectionPointObserver.class)).getEngineIP();
        Assert.assertEquals((Object)configuredOne.getType(), (Object)originalOne.getType());
        Assert.assertEquals((Set)configuredOne.getQualifiers(), (Set)originalOne.getQualifiers());
        Assert.assertEquals((Object)configuredOne.getAnnotated(), (Object)originalOne.getAnnotated());
        Assert.assertEquals((Object)configuredOne.getBean(), (Object)originalOne.getBean());
    }
}

