/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.resource.resource;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.resource.resource.Another;
import org.jboss.cdi.tck.tests.implementation.simple.resource.resource.ManagedBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class InjectionOfResourceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionOfResourceTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertion(section="declaring_resource", id="bb")
    public void testInjectionOfResource() {
        Bean<ManagedBean> managedBeanBean = this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext(managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        assert (managedBean.getBeanManager() != null) : "@Another Manager not found";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="la"), @SpecAssertion(section="resource_lifecycle", id="ma"), @SpecAssertion(section="resource_lifecycle", id="o")})
    public void testProduceResourceProxy() {
        Bean<BeanManager> beanManagerBean = this.getBeans(BeanManager.class, new Annotation[]{new AnnotationLiteral<Another>(){}}).iterator().next();
        CreationalContext beanManagerCc = this.getCurrentManager().createCreationalContext(beanManagerBean);
        BeanManager beanManager = (BeanManager)beanManagerBean.create(beanManagerCc);
        assert (beanManager != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="mb")})
    public void testPassivatingResource() throws Exception {
        Bean<ManagedBean> managedBeanBean = this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext(managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        managedBean = (ManagedBean)this.activate(this.passivate(managedBean));
        assert (managedBean.getBeanManager() != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_types", id="aa")})
    public void testResourceBeanTypes() {
        Bean<BeanManager> beanRemote = this.getBeans(BeanManager.class, new Annotation[]{new AnnotationLiteral<Another>(){}}).iterator().next();
        assert (beanRemote.getTypes().size() == 2);
        assert (beanRemote.getTypes().contains(BeanManager.class));
        assert (beanRemote.getTypes().contains(Object.class));
    }
}

