/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.specialization.qualifiers;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.specialization.qualifiers.DataProvider;
import org.jboss.cdi.tck.tests.inheritance.specialization.qualifiers.Mock;
import org.jboss.cdi.tck.tests.inheritance.specialization.qualifiers.MockSpecializationBean;
import org.jboss.cdi.tck.tests.inheritance.specialization.qualifiers.SpecializationBean;
import org.jboss.cdi.tck.tests.inheritance.specialization.qualifiers.StaticNestedClassesParent;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class SpecializingBeanQualifiersTest
extends AbstractTest {
    @Inject
    BeanManager beanManager;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SpecializingBeanQualifiersTest.class)).build();
    }

    @Test
    @SpecAssertion(section="direct_and_indirect_specialization", id="j")
    public void testQuailifiersOfSpecializingdNestedClass() {
        this.testQualifiersOfSpecializedBean(StaticNestedClassesParent.StaticSpecializationBean.class, StaticNestedClassesParent.StaticMockSpecializationBean.class);
    }

    @Test
    @SpecAssertion(section="direct_and_indirect_specialization", id="j")
    public void testQuailifiersOfSpecializingBean() {
        this.testQualifiersOfSpecializedBean(SpecializationBean.class, MockSpecializationBean.class);
    }

    @Test
    @SpecAssertion(section="direct_and_indirect_specialization", id="j")
    public void testQualifiersOfProducedSpecializingBean() {
        this.testAndReturnSpecializedBeanWithQualifiers(DataProvider.class);
    }

    private void testQualifiersOfSpecializedBean(Class<?> specializedClass, Class<?> specializingClass) {
        Bean<?> bean = this.testAndReturnSpecializedBeanWithQualifiers(specializedClass);
        Assert.assertTrue((boolean)bean.getTypes().contains(specializingClass));
    }

    private Bean<?> testAndReturnSpecializedBeanWithQualifiers(Class<?> specializedClass) {
        Set specializationBeans = this.beanManager.getBeans(specializedClass, new Annotation[]{new Mock.MockLiteral()});
        Assert.assertEquals((int)1, (int)specializationBeans.size());
        Bean bean = (Bean)specializationBeans.iterator().next();
        Set qualifiers = bean.getQualifiers();
        Assert.assertEquals((int)2, (int)qualifiers.size());
        Assert.assertTrue((boolean)qualifiers.contains(Any.Literal.INSTANCE));
        Assert.assertTrue((boolean)qualifiers.contains(new Mock.MockLiteral()));
        return bean;
    }
}

