/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.container.contextualReference;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.container.contextualReference.FooBean;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class InvalidContextualReferenceTest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() {
        JavaArchive testArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(InvalidContextualReferenceTest.class.getPackage())).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        return ClassPath.builder().add(testArchive).build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertions(value={@SpecAssertion(section="contextual_reference_validity", id="b")})
    public void testReferenceUsedAfterContainerShutdown() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        FooBean beanReferenceOutsideContainer = null;
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{FooBean.class}).initialize();){
            FooBean validBeanReference = (FooBean)seContainer.select(FooBean.class, new Annotation[0]).get();
            validBeanReference.ping();
            beanReferenceOutsideContainer = validBeanReference;
        }
        beanReferenceOutsideContainer.ping();
    }
}

