/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.bindings.members;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.bindings.members.DecreasingInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.members.Farm;
import org.jboss.cdi.tck.interceptors.tests.bindings.members.IncreasingInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.members.Plant;
import org.jboss.cdi.tck.interceptors.tests.bindings.members.PlantInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.members.PlantInterceptorBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.members.VehicleCountInterceptor;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="1.2")
public class InterceptorBindingTypeWithMemberTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorBindingTypeWithMemberTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{IncreasingInterceptor.class.getName(), DecreasingInterceptor.class.getName(), VehicleCountInterceptor.class.getName(), PlantInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertion(section="3.4.2", id="a")
    public void testInterceptorBindingTypeWithMember() {
        Farm farm = this.getContextualReference(Farm.class, new Annotation[0]);
        Assert.assertEquals((int)farm.getAnimalCount(), (int)20);
        Assert.assertTrue((boolean)IncreasingInterceptor.isIntercepted());
        Assert.assertFalse((boolean)DecreasingInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="3.4.2", id="c")
    public void testInterceptorBindingTypeWithNonBindingMember() {
        Farm farm = this.getContextualReference(Farm.class, new Annotation[0]);
        assert (farm.getVehicleCount() == 20);
        assert (VehicleCountInterceptor.isIntercepted());
    }

    @Test
    @SpecAssertion(section="3.4.2", id="b")
    public void testInterceptorBindingTypeMemberValuesComparedWithEquals() {
        List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new PlantInterceptorBindingLiteral(){

            @Override
            public String name() {
                return new String("TEST");
            }

            @Override
            public int age() {
                return 1;
            }
        }});
        Assert.assertTrue((interceptors.size() > 0 ? 1 : 0) != 0);
        Plant plant = this.getContextualReference(Plant.class, new Annotation[0]);
        plant.grow();
        Assert.assertTrue((boolean)PlantInterceptor.isIntercepted());
    }

    public abstract class PlantInterceptorBindingLiteral
    extends AnnotationLiteral<PlantInterceptorBinding>
    implements PlantInterceptorBinding {
    }
}

