/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.broken.producer.field.enterprise;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.IllegalProductException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.field.enterprise.ConstructorInjectionCorralBroken;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.field.enterprise.Corral;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.field.enterprise.FieldInjectionCorralBroken;
import org.jboss.cdi.tck.tests.context.passivating.broken.producer.field.enterprise.SetterInjectionCorralBroken;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class EnterpriseBeanWithIllegalDependencyTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseBeanWithIllegalDependencyTest.class)).build();
    }

    @Test
    @SpecAssertion(section="passivation_validation_ee", id="fbb")
    public void testFieldInjectionPointRequiringPassivationCapableDependency() {
        this.verify(FieldInjectionCorralBroken.class);
    }

    @Test
    @SpecAssertion(section="passivation_validation_ee", id="fbb")
    public void testSetterInjectionPointRequiringPassivationCapableDependency() {
        this.verify(SetterInjectionCorralBroken.class);
    }

    @Test
    @SpecAssertion(section="passivation_validation_ee", id="fbb")
    public void testConstructorInjectionPointRequiringPassivationCapableDependency() {
        this.verify(ConstructorInjectionCorralBroken.class);
    }

    private void verify(Class<? extends Corral> clazz) {
        try {
            this.getContextualReference(clazz, new Annotation[0]).ping();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalProductException.class, t));
            return;
        }
        Assert.fail();
    }
}

