/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.jaxrs;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.jaxrs.JaxRsActivator;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class RequestContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextTest.class)).withClass(JaxRsActivator.class)).build();
    }

    @Test(groups={"integration", "jaxrs"})
    @SpecAssertions(value={@SpecAssertion(section="request_context_ee", id="b"), @SpecAssertion(section="request_context_ee", id="d"), @SpecAssertion(section="request_context_ee", id="jb")})
    public void testRequestScopeActiveDuringWebServiceInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage resource01 = (TextPage)webClient.getPage(this.contextPath + "rest/foo");
        Long id01 = Long.valueOf(resource01.getContent());
        TextPage resource02 = (TextPage)webClient.getPage(this.contextPath + "rest/foo");
        Long id02 = Long.valueOf(resource02.getContent());
        Assert.assertNotEquals((Object)id01, (Object)id02);
        TextPage resource03 = (TextPage)webClient.getPage(this.contextPath + "info");
        Assert.assertTrue((boolean)resource03.getContent().contains("Initialized requests:3"));
        Assert.assertTrue((boolean)resource03.getContent().contains("Destroyed requests:2"));
        Assert.assertTrue((boolean)resource03.getContent().contains("Foo destroyed:2"));
    }
}

