/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.bean.types.illegal;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.bean.types.illegal.AnimalHolder;
import org.jboss.cdi.tck.tests.definition.bean.types.illegal.Eagle;
import org.jboss.cdi.tck.tests.definition.bean.types.illegal.ProducedWithField;
import org.jboss.cdi.tck.tests.definition.bean.types.illegal.ProducedWithMethod;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class BeanTypesWithIllegalTypeTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanTypesWithIllegalTypeTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="managed_bean_types", id="b")})
    public void beanSetOfBeanTypesContainsOnlyLegalTypes() {
        this.getUniqueEagleAndCheckItsTypes(new Annotation[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_field_types", id="d")})
    public void producerFieldsetOfBeanTypesContainsOnlyLegalTypes() {
        this.getUniqueEagleAndCheckItsTypes(ProducedWithField.ProducedWithFieldLiteral.INSTANCE);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_types", id="d")})
    public void producerMethodsetOfBeanTypesContainsOnlyLegalTypes() {
        this.getUniqueEagleAndCheckItsTypes(ProducedWithMethod.ProducedWithMethoddLiteral.INSTANCE);
    }

    private void getUniqueEagleAndCheckItsTypes(Annotation ... annotations) {
        Bean<Eagle> eagleBean = this.getUniqueBean(Eagle.class, annotations);
        for (Type type : eagleBean.getTypes()) {
            if (!(type instanceof ParameterizedType)) continue;
            Assert.assertNotEquals((Object)((ParameterizedType)type).getRawType(), AnimalHolder.class);
        }
        Assert.assertEquals((int)eagleBean.getTypes().size(), (int)3);
    }
}

