/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.qualifier.repeatable;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.qualifier.repeatable.Process;
import org.jboss.cdi.tck.tests.definition.qualifier.repeatable.ProcessObserver;
import org.jboss.cdi.tck.tests.definition.qualifier.repeatable.Start;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class RepeatableQualifiersTest
extends AbstractTest {
    private static final Start.StartLiteral A = new Start.StartLiteral("A");
    private static final Start.StartLiteral B = new Start.StartLiteral("B");
    private static final Start.StartLiteral C = new Start.StartLiteral("C");
    @Inject
    @Any
    Instance<Process> processInstance;
    @Inject
    ProcessObserver observer;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RepeatableQualifiersTest.class)).build();
    }

    @Test
    @SpecAssertion(section="repeating_qualifiers", id="a")
    public void resolutionWithRepeatableQualifiers() {
        Assert.assertEquals((long)this.processInstance.stream().count(), (long)4L);
        Assert.assertTrue((boolean)this.processInstance.select(new Annotation[]{A}).isResolvable());
        Assert.assertFalse((boolean)this.processInstance.select(new Annotation[]{B}).isResolvable());
        Assert.assertTrue((boolean)this.processInstance.select(new Annotation[]{C}).isResolvable());
        Assert.assertTrue((boolean)this.processInstance.select(new Annotation[]{B, C}).isResolvable());
        Assert.assertEquals((int)this.observer.getProcessAObserved(), (int)1);
        Assert.assertEquals((int)this.observer.getProcessBObserved(), (int)2);
        Assert.assertEquals((int)this.observer.getProcessABObserved(), (int)1);
        Assert.assertEquals((int)this.observer.getProcessAMetadata().getQualifiers().size(), (int)3);
        Assert.assertTrue((boolean)this.observer.getProcessAMetadata().getQualifiers().contains(A));
        Assert.assertEquals((int)this.observer.getProcessBCMetadata().getQualifiers().size(), (int)4);
        Assert.assertTrue((boolean)this.observer.getProcessBCMetadata().getQualifiers().contains(B));
        Assert.assertTrue((boolean)this.observer.getProcessBCMetadata().getQualifiers().contains(C));
    }
}

