/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.fires;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.fires.Bar;
import org.jboss.cdi.tck.tests.event.fires.Billing;
import org.jboss.cdi.tck.tests.event.fires.ContainerLifecycleEventDispatcher;
import org.jboss.cdi.tck.tests.event.fires.DogWhisperer;
import org.jboss.cdi.tck.tests.event.fires.DoggiePoints;
import org.jboss.cdi.tck.tests.event.fires.Housekeeping;
import org.jboss.cdi.tck.tests.event.fires.Item;
import org.jboss.cdi.tck.tests.event.fires.Item_Illegal;
import org.jboss.cdi.tck.tests.event.fires.Lifted;
import org.jboss.cdi.tck.tests.event.fires.MiniBar;
import org.jboss.cdi.tck.tests.extensions.beanManager.broken.event.ContainerLifecycleEvents;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-PFD")
public class FireEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(FireEventTest.class)).withClass(ContainerLifecycleEvents.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_fire_event", id="a"), @SpecAssertion(section="bm_fire_event", id="b")})
    public void testBeanManagerFireEvent() {
        Billing billing = this.getContextualReference(Billing.class, new Annotation[0]);
        billing.reset();
        MiniBar miniBar = new MiniBar();
        miniBar.stockNoNotify();
        this.getCurrentManager().fireEvent((Object)miniBar, new Annotation[0]);
        Assert.assertTrue((boolean)billing.isActive());
        Item chocolate = miniBar.getItemByName("Chocolate");
        this.getCurrentManager().fireEvent((Object)chocolate, new Annotation[]{new Lifted.LiftedLiteral(){}});
        Assert.assertEquals((int)billing.getCharge(), (int)5);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_fire_event", id="c")
    public void testTypeVariableEventTypeFails() throws Exception {
        this.getContextualReference(Bar.class, new Annotation[0]).fireWithTypeVariable();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_fire_event", id="d")
    public void testDuplicateBindingsToFireEventFails() throws Exception {
        this.getCurrentManager().fireEvent(new Object(), new Annotation[]{new Lifted.LiftedLiteral("a"){}, new Lifted.LiftedLiteral("b"){}});
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="firing_events", id="a")
    public void testInjectedAnyEventCanFireEvent() {
        Billing billing = this.getContextualReference(Billing.class, new Annotation[0]);
        billing.reset();
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        InjectionPoint eventInjection = null;
        for (InjectionPoint candidate : miniBarBean.getInjectionPoints()) {
            if (!candidate.getMember().getName().equals("miniBarEvent")) continue;
            eventInjection = candidate;
            break;
        }
        Assert.assertNotNull(eventInjection);
        Assert.assertEquals((int)eventInjection.getQualifiers().size(), (int)1);
        Assert.assertTrue((boolean)eventInjection.getQualifiers().contains(Any.Literal.INSTANCE));
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        miniBar.stock();
        Assert.assertTrue((boolean)billing.isActive());
        Assert.assertEquals((int)billing.getMiniBarValue(), (int)16);
    }

    @Test(groups={"rewrite"})
    @SpecAssertions(value={@SpecAssertion(section="firing_events_synchronously", id="b"), @SpecAssertion(section="event", id="cb")})
    public void testInjectedEventAcceptsEventObject() throws SecurityException, NoSuchFieldException, NoSuchMethodException {
        Billing billing = this.getContextualReference(Billing.class, new Annotation[0]);
        billing.reset();
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        Field eventField = miniBar.getClass().getDeclaredField("miniBarEvent");
        ParameterizedType eventFieldType = (ParameterizedType)eventField.getGenericType();
        Assert.assertEquals((int)eventFieldType.getActualTypeArguments().length, (int)1);
        Assert.assertEquals(MiniBar.class, (Object)eventFieldType.getActualTypeArguments()[0]);
        Assert.assertEquals(Event.class, (Object)eventFieldType.getRawType());
        Method fireMethod = null;
        Class eventFieldClass = (Class)eventFieldType.getRawType();
        for (Method method : eventFieldClass.getMethods()) {
            if (!method.getName().equals("fire") || method.isSynthetic()) continue;
            if (fireMethod != null) {
                Assert.fail((String)"Expecting exactly one method on Event named 'fire'");
            }
            fireMethod = method;
        }
        if (fireMethod == null) {
            Assert.fail((String)"Expecting exactly one method on Event named 'fire'");
        }
        Assert.assertEquals((int)fireMethod.getParameterTypes().length, (int)1);
        Assert.assertEquals((int)fireMethod.getGenericParameterTypes().length, (int)1);
        Type fireMethodArgumentType = fireMethod.getGenericParameterTypes()[0];
        TypeVariable<?> eventClassParameterizedType = ((TypeVariable)fireMethod.getGenericParameterTypes()[0]).getGenericDeclaration().getTypeParameters()[0];
        Assert.assertEquals((Object)fireMethodArgumentType, eventClassParameterizedType);
        miniBar.stock();
        Assert.assertTrue((boolean)billing.isActive());
        Assert.assertEquals((int)billing.getMiniBarValue(), (int)16);
    }

    @Test(groups={"rewrite"})
    @SpecAssertions(value={@SpecAssertion(section="firing_events", id="c"), @SpecAssertion(section="event", id="cb")})
    public void testInjectedEventCanHaveBindings() {
        Billing billing = this.getContextualReference(Billing.class, new Annotation[0]);
        billing.reset();
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        InjectionPoint eventInjection = null;
        for (InjectionPoint candidate : miniBarBean.getInjectionPoints()) {
            if (!candidate.getMember().getName().equals("itemLiftedEvent")) continue;
            eventInjection = candidate;
            break;
        }
        Assert.assertNotNull(eventInjection);
        Assert.assertEquals((int)eventInjection.getQualifiers().size(), (int)1);
        Assert.assertTrue((boolean)eventInjection.getQualifiers().contains(new Lifted.LiftedLiteral(){}));
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        miniBar.stock();
        Item chocolate = miniBar.getItemByName("Chocolate");
        Assert.assertNotNull((Object)chocolate);
        miniBar.liftItem(chocolate);
        Assert.assertEquals((int)billing.getCharge(), (int)chocolate.getPrice());
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="firing_events", id="d")
    public void testInjectedEventCanSpecifyBindingsDynamically() {
        Billing billing = this.getContextualReference(Billing.class, new Annotation[0]);
        billing.reset();
        Housekeeping housekeeping = this.getContextualReference(Housekeeping.class, new Annotation[0]);
        Bean<MiniBar> miniBarBean = this.getUniqueBean(MiniBar.class, new Annotation[0]);
        InjectionPoint eventInjection = null;
        for (InjectionPoint candidate : miniBarBean.getInjectionPoints()) {
            if (!candidate.getMember().getName().equals("itemEvent")) continue;
            eventInjection = candidate;
            break;
        }
        Assert.assertNotNull(eventInjection);
        Assert.assertEquals((int)eventInjection.getQualifiers().size(), (int)1);
        Assert.assertTrue((boolean)eventInjection.getQualifiers().contains(Any.Literal.INSTANCE));
        CreationalContext miniBarCc = this.getCurrentManager().createCreationalContext(miniBarBean);
        MiniBar miniBar = (MiniBar)miniBarBean.create(miniBarCc);
        miniBar.stock();
        Item water = miniBar.liftItemByName("16 oz Water");
        miniBar.restoreItem(water);
        Assert.assertEquals((int)billing.getCharge(), (int)1);
        Assert.assertEquals((int)housekeeping.getItemsTainted().size(), (int)1);
        Assert.assertTrue((boolean)housekeeping.getItemsTainted().contains(water));
    }

    @Test
    @SpecAssertion(section="event", id="ca")
    public void testEventProvidesMethodForFiringEventsWithCombinationOfTypeAndBindings() {
        DoggiePoints points = this.getContextualReference(DoggiePoints.class, new Annotation[0]);
        points.reset();
        DogWhisperer master = this.getContextualReference(DogWhisperer.class, new Annotation[0]);
        master.issueTamingCommand();
        Assert.assertEquals((int)points.getNumTamed(), (int)1);
        Assert.assertEquals((int)points.getNumPraiseReceived(), (int)0);
        master.givePraise();
        Assert.assertEquals((int)points.getNumTamed(), (int)1);
        Assert.assertEquals((int)points.getNumPraiseReceived(), (int)1);
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="event", id="eda")
    public void testEventSelectedFiresAndObserversNotified() {
        Housekeeping houseKeeping = this.getContextualReference(Housekeeping.class, new Annotation[0]);
        houseKeeping.reset();
        MiniBar miniBar = this.getContextualReference(MiniBar.class, new Annotation[0]);
        Item chocolate = new Item("Chocolate", 5);
        Item crackers = new Item("Crackers", 2);
        miniBar.getItemEvent().fire((Object)chocolate);
        Assert.assertEquals((int)houseKeeping.getItemActivity().size(), (int)1);
        Assert.assertEquals((Object)houseKeeping.getItemActivity().get(0), (Object)chocolate);
        miniBar.getItemEvent().select(new Annotation[]{new Lifted.LiftedLiteral(){}}).fire((Object)crackers);
        Assert.assertEquals((int)houseKeeping.getItemActivity().size(), (int)2);
        Assert.assertEquals((Object)houseKeeping.getItemActivity().get(1), (Object)crackers);
        Assert.assertEquals((int)houseKeeping.getItemsMissing().size(), (int)1);
        Assert.assertEquals((Object)houseKeeping.getItemsMissing().iterator().next(), (Object)crackers);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="event", id="f"), @SpecAssertion(section="observer_resolution", id="j")})
    public <T> void testEventFireThrowsExceptionIfEventObjectTypeContainsUnresovableTypeVariable() {
        MiniBar miniBar = this.getContextualReference(MiniBar.class, new Annotation[0]);
        miniBar.itemEvent.fire(new Item_Illegal("12 oz Beer", 6));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="event", id="g")
    public void testFireContainerLifecycleEvent(ContainerLifecycleEventDispatcher containerLifecycleEvents) {
        containerLifecycleEvents.fireContainerLifecycleEvents();
    }
}

