/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BlackWidow;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BlackWidowConsumer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BlackWidowProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.Broken;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.BrownRecluse;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.DefangedTarantula;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.Null;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.NullSpiderConsumer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.NullSpiderConsumerForBrokenProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.StaticTarantulaConsumer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.StaticTarantulaProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.Tame;
import org.jboss.cdi.tck.tests.implementation.producer.field.lifecycle.TarantulaConsumer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class ProducerFieldLifecycleTest
extends AbstractTest {
    private AnnotationLiteral<Null> NULL_LITERAL = new AnnotationLiteral<Null>(){};
    private AnnotationLiteral<Broken> BROKEN_LITERAL = new AnnotationLiteral<Broken>(){};
    private AnnotationLiteral<Tame> TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerFieldLifecycleTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_field", id="a")})
    public void testProducerFieldNotAnotherBean() {
        assert (this.getContextualReference(BrownRecluse.class, new Annotation[0]) != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_fields_access", id="a"), @SpecAssertion(section="producer_field", id="b")})
    public void testProducerStaticFieldBean() {
        StaticTarantulaConsumer tarantulaConsumer = this.getContextualReference(StaticTarantulaConsumer.class, new Annotation[0]);
        assert (tarantulaConsumer.getConsumedTarantula().equals(StaticTarantulaProducer.produceTarantula));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_fields_access", id="b"), @SpecAssertion(section="producer_field_lifecycle", id="ga")})
    public void testProducerFieldBeanCreate() throws Exception {
        BlackWidowConsumer spiderConsumer = this.getContextualReference(BlackWidowConsumer.class, new Annotation[0]);
        assert (spiderConsumer.getInjectedSpider().equals(BlackWidowProducer.blackWidow));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="specialization", id="cd")})
    public void testProducerFieldFromSpecializingBeanUsed() throws Exception {
        TarantulaConsumer spiderConsumer = this.getContextualReference(TarantulaConsumer.class, new Annotation[0]);
        assert (spiderConsumer.getConsumedTarantula() != null);
        assert (spiderConsumer.getConsumedTarantula() instanceof DefangedTarantula);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_field", id="d"), @SpecAssertion(section="producer_field_lifecycle", id="m")})
    public void testProducerFieldReturnsNullIsDependent() throws Exception {
        NullSpiderConsumer consumerBean = this.getContextualReference(NullSpiderConsumer.class, new Annotation[0]);
        assert (consumerBean.getInjectedSpider() == null);
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertions(value={@SpecAssertion(section="producer_field_lifecycle", id="n")})
    public void testProducerFieldForNullValueNotDependent() throws Exception {
        Bean<BlackWidow> spiderBean = this.getBeans(BlackWidow.class, new Annotation[]{this.NULL_LITERAL, this.BROKEN_LITERAL}).iterator().next();
        CreationalContext spiderContext = this.getCurrentManager().createCreationalContext(spiderBean);
        spiderBean.create(spiderContext);
        assert (false);
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertions(value={@SpecAssertion(section="producer_field", id="e"), @SpecAssertion(section="producer_field_lifecycle", id="n")})
    public void testProducerFieldReturnsNullIsNotDependent() throws Exception {
        NullSpiderConsumerForBrokenProducer consumer = this.getContextualReference(NullSpiderConsumerForBrokenProducer.class, new Annotation[0]);
        if (consumer.getInjectedSpider() != null) {
            consumer.getInjectedSpider().bite();
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_field_lifecycle", id="o")})
    public void testProducerFieldBeanDestroy() throws Exception {
        BlackWidowProducer.reset();
        Bean<BlackWidow> bean = this.getUniqueBean(BlackWidow.class, new Annotation[]{this.TAME_LITERAL});
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        BlackWidow instance = (BlackWidow)bean.create(ctx);
        bean.destroy((Object)instance, ctx);
        Assert.assertTrue((boolean)BlackWidowProducer.blackWidowDestroyed);
        Assert.assertEquals((long)BlackWidowProducer.destroyedBlackWidowTimeOfBirth, (long)instance.getTimeOfBirth());
    }
}

