/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.initializer;

import java.math.BigDecimal;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.initializer.AppleEjb;
import org.jboss.cdi.tck.tests.inheritance.initializer.Cheap;
import org.jboss.cdi.tck.tests.inheritance.initializer.Citrus;
import org.jboss.cdi.tck.tests.inheritance.initializer.CitrusEjb;
import org.jboss.cdi.tck.tests.inheritance.initializer.Expensive;
import org.jboss.cdi.tck.tests.inheritance.initializer.FirstLevel;
import org.jboss.cdi.tck.tests.inheritance.initializer.Lemon;
import org.jboss.cdi.tck.tests.inheritance.initializer.Orange;
import org.jboss.cdi.tck.tests.inheritance.initializer.OrangeEjb;
import org.jboss.cdi.tck.tests.inheritance.initializer.SecondLevel;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class InitializerMethodInheritanceTest
extends AbstractTest {
    @Inject
    @Cheap
    BigDecimal cheap;
    @Inject
    @Expensive
    BigDecimal expensive;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InitializerMethodInheritanceTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="dm")
    public void testManagedBeanDirectlyInheritsInitializer(@FirstLevel Citrus citrus) {
        Assert.assertEquals((Object)citrus.getPrice(), (Object)this.cheap);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="do")
    public void testManagedBeanIndirectlyInheritsInitializer(@SecondLevel Orange orange, @SecondLevel Lemon lemon) {
        Assert.assertEquals((Object)orange.getPrice(), (Object)this.cheap);
        Assert.assertEquals((Object)lemon.getPrice(), (Object)this.expensive);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance_ee", id="dn")
    public void testSessionBeanDirectlyInheritsInitializer(@FirstLevel CitrusEjb citrus, @FirstLevel AppleEjb apple) {
        Assert.assertEquals((Object)citrus.getPrice(), (Object)this.cheap);
        Assert.assertEquals((Object)apple.getPrice(), (Object)this.expensive);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance_ee", id="dp")
    public void testSessionBeanIndirectlyInheritsInitializer(@SecondLevel OrangeEjb orange) {
        Assert.assertEquals((Object)orange.getPrice(), (Object)this.cheap);
    }
}

