/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.Bar;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.Foo;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.Nice;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.NiceFoo;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-PFD")
public class DynamicInjectionPointTest
extends AbstractTest {
    @Inject
    Bar bar;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DynamicInjectionPointTest.class)).build();
    }

    @Test
    @SpecAssertion(section="injection_point", id="aab")
    public void testInjectionPointGetBean() {
        Assert.assertEquals((Object)this.bar.getFoo().getInjectionPoint().getBean(), this.getUniqueBean(Bar.class, new Annotation[0]));
    }

    @Test
    @SpecAssertion(section="injection_point", id="baa")
    public void testInjectionPointGetType() {
        Assert.assertEquals((Object)this.bar.getFoo().getInjectionPoint().getType(), Foo.class);
        Assert.assertEquals((Object)this.bar.getTypeNiceFoo().getInjectionPoint().getType(), NiceFoo.class);
    }

    @Test
    @SpecAssertion(section="injection_point", id="bca")
    public void testInjectionPointGetQualifiers() {
        Set fooQualifiers = this.bar.getFoo().getInjectionPoint().getQualifiers();
        Set niceFooQualifiers = this.bar.getQualifierNiceFoo().getInjectionPoint().getQualifiers();
        this.annotationSetMatches((Set<? extends Annotation>)fooQualifiers, new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE});
        this.annotationSetMatches((Set<? extends Annotation>)niceFooQualifiers, new Annotation[]{Any.Literal.INSTANCE, new AnnotationLiteral<Nice>(){}});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="caa"), @SpecAssertion(section="injection_point", id="cba"), @SpecAssertion(section="injection_point", id="cca")})
    public void testInjectionPointGetMember() {
        Member fieldMember = this.bar.getFoo().getInjectionPoint().getMember();
        Assert.assertNotNull((Object)fieldMember);
        Assert.assertTrue((boolean)(fieldMember instanceof Field));
        Field field = (Field)fieldMember;
        Assert.assertEquals((String)field.getName(), (String)"fooInstance");
        Assert.assertEquals(field.getType(), Instance.class);
        Assert.assertEquals(field.getDeclaringClass(), Bar.class);
        Member methodMember = this.bar.getInitializerFoo().getInjectionPoint().getMember();
        Assert.assertNotNull((Object)methodMember);
        Assert.assertTrue((boolean)(methodMember instanceof Method));
        Method method = (Method)methodMember;
        Assert.assertEquals((String)method.getName(), (String)"setInitializerInjectionFooInstance");
        Assert.assertEquals((int)method.getParameterTypes().length, (int)1);
        Assert.assertEquals(method.getDeclaringClass(), Bar.class);
        Member constructorMember = this.bar.getConstructorInjectionFoo().getInjectionPoint().getMember();
        Assert.assertNotNull((Object)constructorMember);
        Assert.assertTrue((boolean)(constructorMember instanceof Constructor));
        Constructor constructor = (Constructor)constructorMember;
        Assert.assertTrue(("org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.Bar".equals(constructor.getName()) || "Bar".equals(constructor.getName()) ? 1 : 0) != 0);
        Assert.assertNotNull((Object)constructor.getAnnotation(Inject.class));
        Assert.assertEquals(constructor.getDeclaringClass(), Bar.class);
    }

    @Test
    @SpecAssertion(section="injection_point", id="dab")
    public void testInjectionPointGetAnnotated() {
        Annotated fooFieldAnnotated = this.bar.getFoo().getInjectionPoint().getAnnotated();
        Assert.assertTrue((boolean)(fooFieldAnnotated instanceof AnnotatedField));
        Assert.assertEquals((String)((AnnotatedField)fooFieldAnnotated).getJavaMember().getName(), (String)"fooInstance");
        Assert.assertTrue((boolean)fooFieldAnnotated.isAnnotationPresent(Any.class));
        Annotated fooInitializerAnnnotated = this.bar.getInitializerFoo().getInjectionPoint().getAnnotated();
        Assert.assertTrue((boolean)(fooInitializerAnnnotated instanceof AnnotatedParameter));
        Assert.assertEquals((int)((AnnotatedParameter)fooInitializerAnnnotated).getPosition(), (int)0);
        Annotated fooConstructorAnnnotated = this.bar.getConstructorInjectionFoo().getInjectionPoint().getAnnotated();
        Assert.assertTrue((boolean)(fooConstructorAnnnotated instanceof AnnotatedParameter));
        Assert.assertEquals((int)((AnnotatedParameter)fooConstructorAnnnotated).getPosition(), (int)0);
    }

    @Test
    @SpecAssertion(section="injection_point", id="dbb")
    public void testInjectionPointIsDelegate() {
        Assert.assertFalse((boolean)this.bar.getFoo().getInjectionPoint().isDelegate());
    }

    @Test
    @SpecAssertion(section="injection_point", id="dcb")
    public void testInjectionPointIsTransient() {
        Assert.assertTrue((boolean)this.bar.getTransientFoo().getInjectionPoint().isTransient());
        Assert.assertFalse((boolean)this.bar.getFoo().getInjectionPoint().isTransient());
    }
}

