/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.context;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.context.ApplicationScopedCounter;
import org.jboss.cdi.tck.tests.se.context.ApplicationScopedObserver;
import org.jboss.cdi.tck.tests.se.context.Bar;
import org.jboss.cdi.tck.tests.se.context.Baz;
import org.jboss.cdi.tck.tests.se.context.Foo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class ContextSETest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() {
        JavaArchive testArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ContextSETest.class, ApplicationScopedCounter.class, ApplicationScopedObserver.class})).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        JavaArchive fooArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Foo.class})).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        JavaArchive barArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Bar.class})).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        JavaArchive bazArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Baz.class})).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        return ClassPath.builder().add(new JavaArchive[]{testArchive, fooArchive, barArchive, bazArchive}).build();
    }

    @Test
    @SpecAssertion(section="application_context_se", id="a")
    public void applicationContextSharedBetweenAllBeansWithinContainer() {
        try (SeContainer seContainer = SeContainerInitializer.newInstance().initialize();){
            ((Foo)seContainer.select(Foo.class, new Annotation[0]).get()).ping();
            ((Bar)seContainer.select(Bar.class, new Annotation[0]).get()).ping();
            ((Baz)seContainer.select(Baz.class, new Annotation[0]).get()).ping();
            ApplicationScopedCounter applicationScopedCounter = (ApplicationScopedCounter)seContainer.select(ApplicationScopedCounter.class, new Annotation[0]).get();
            Assert.assertEquals((int)applicationScopedCounter.getCount(), (int)3);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="application_context_se", id="b"), @SpecAssertion(section="application_context_se", id="d"), @SpecAssertion(section="se_bootstrap", id="f"), @SpecAssertion(section="se_bootstrap", id="f"), @SpecAssertion(section="application_context", id="a")})
    public void testEventIsFiredWhenAplicationContextInitialized() {
        ApplicationScopedObserver.reset();
        try (SeContainer seContainer = SeContainerInitializer.newInstance().initialize();){
            Assert.assertTrue((boolean)ApplicationScopedObserver.isInitialized);
            Assert.assertNotNull((Object)ApplicationScopedObserver.initializedEventPayload);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="application_context_se", id="c"), @SpecAssertion(section="application_context_se", id="d"), @SpecAssertion(section="application_context", id="b"), @SpecAssertion(section="application_context", id="c")})
    public void testEventIsFiredWhenAplicationContextDestroyed() {
        ApplicationScopedObserver.reset();
        SeContainer seContainer = SeContainerInitializer.newInstance().initialize();
        Throwable throwable = null;
        if (seContainer != null) {
            if (throwable != null) {
                try {
                    seContainer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                seContainer.close();
            }
        }
        Assert.assertTrue((boolean)ApplicationScopedObserver.isBeforeDestroyed);
        Assert.assertNotNull((Object)ApplicationScopedObserver.beforeDestroyedEventPayload);
        Assert.assertTrue((boolean)ApplicationScopedObserver.isDestroyed);
        Assert.assertNotNull((Object)ApplicationScopedObserver.destroyedEventPayload);
    }
}

