/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.context.activation.interceptor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.context.activation.interceptor.AfterActivationInterceptor;
import org.jboss.cdi.tck.tests.se.context.activation.interceptor.BeforeActivationInterceptor;
import org.jboss.cdi.tck.tests.se.context.activation.interceptor.ClassInterceptorContextActivator;
import org.jboss.cdi.tck.tests.se.context.activation.interceptor.MethodInterceptorContextActivator;
import org.jboss.cdi.tck.tests.se.context.activation.interceptor.RequestContextObserver;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0-PFD")
public class ActivateRequestContextByInterceptorTest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() throws IOException {
        JavaArchive bda1 = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(ActivateRequestContextByInterceptorTest.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return ClassPath.builder().add(bda1).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="a"), @SpecAssertion(section="request_context", id="b"), @SpecAssertion(section="request_context", id="c"), @SpecAssertion(section="activating_request_context", id="a"), @SpecAssertion(section="activating_request_context", id="f")})
    public void classInterceptorRequestContextActivation() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            ClassInterceptorContextActivator activator = (ClassInterceptorContextActivator)container.select(ClassInterceptorContextActivator.class, new Annotation[0]).get();
            Assert.assertEquals((int)activator.callRequestScopeBean(), (int)11);
            RequestContextObserver requestContextObserver = (RequestContextObserver)container.select(RequestContextObserver.class, new Annotation[0]).get();
            Assert.assertEquals((int)requestContextObserver.getInitCounter(), (int)1);
            Assert.assertEquals((int)requestContextObserver.getBeforeDestroyedCounter(), (int)1);
            Assert.assertEquals((int)requestContextObserver.getDestroyedCounter(), (int)1);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="a"), @SpecAssertion(section="request_context", id="b"), @SpecAssertion(section="request_context", id="c"), @SpecAssertion(section="activating_request_context", id="a"), @SpecAssertion(section="activating_request_context", id="f")})
    public void methodInterceptorRequestContextActivation() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            MethodInterceptorContextActivator activator = (MethodInterceptorContextActivator)container.select(MethodInterceptorContextActivator.class, new Annotation[0]).get();
            Assert.assertEquals((int)activator.callRequestScopeBean(), (int)11);
            RequestContextObserver requestContextObserver = (RequestContextObserver)container.select(RequestContextObserver.class, new Annotation[0]).get();
            Assert.assertEquals((int)requestContextObserver.getInitCounter(), (int)1);
            Assert.assertEquals((int)requestContextObserver.getBeforeDestroyedCounter(), (int)1);
            Assert.assertEquals((int)requestContextObserver.getDestroyedCounter(), (int)1);
        }
    }

    @Test
    @SpecAssertion(section="activating_request_context", id="g")
    public void builtInInterceptorHasGivenPriority() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            ClassInterceptorContextActivator activator = (ClassInterceptorContextActivator)container.select(ClassInterceptorContextActivator.class, new Annotation[0]).get();
            activator.callRequestScopeBean();
            Assert.assertFalse((boolean)BeforeActivationInterceptor.isRequestContextActive.get());
            Assert.assertTrue((boolean)AfterActivationInterceptor.isRequestContextActive.get());
        }
    }
}

