/*
 * Decompiled with CFR 0.152.
 */
package org.fuse.cidpoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Item {
    public String getVName() {
        return this.getClass().getSimpleName() + "-" + Item.getVersion(this.getClass());
    }

    public abstract List<Item> getDependencies();

    public abstract Capability getCapability();

    public List<Requirement> getRequirements() {
        return Collections.emptyList();
    }

    public boolean isSatisfied() {
        boolean result = true;
        for (Item item : this.getDependencies()) {
            if (item.isSatisfied()) continue;
            result = false;
        }
        for (Requirement req : this.getRequirements()) {
            boolean match = false;
            for (Item item : this.getDependencies()) {
                if (!req.matches(item.getCapability())) continue;
                match = true;
            }
            result &= match;
        }
        return result;
    }

    public String getStatus() {
        return (this.isSatisfied() ? "is " : "is NOT ") + "satisfied";
    }

    public void transitiveStatus() {
        this.transitiveStatus(new HashSet<String>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion(Class<?> clazz) {
        try (InputStream ins = clazz.getResourceAsStream("version");){
            String string = new BufferedReader(new InputStreamReader(ins)).readLine();
            return string;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void transitiveStatus(Set<String> visited) {
        if (!visited.contains(this.getVName())) {
            for (Item item : this.getDependencies()) {
                item.transitiveStatus(visited);
            }
            System.out.println(this.getVName());
            System.out.println("Dependencies: " + this.getDependencies());
            System.out.println("Provides: " + this.getCapability());
            System.out.println("Requires: " + this.getRequirements());
            System.out.println(this.getStatus());
            System.out.println();
            visited.add(this.getVName());
        }
    }

    public String toString() {
        return this.getVName();
    }

    public static class Requirement {
        private final String name;
        private final int min;
        private final int max;

        public Requirement(String name, int min, int max) {
            this.name = name;
            this.min = min;
            this.max = max;
        }

        public String getName() {
            return this.name;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean matches(Capability cap) {
            return this.name.equals(cap.getName()) && this.min <= cap.getValue() && cap.getValue() <= this.max;
        }

        public String toString() {
            return this.name + "(" + this.min + "-" + this.max + ")";
        }
    }

    public static class Capability {
        private final String name;
        private final int value;

        public Capability(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + this.value;
        }
    }
}

