/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseDelegateLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderInformation {
    private BaseClassLoader classLoader;
    private BaseClassLoaderPolicy policy;
    private int order;
    private List<? extends DelegateLoader> delegates;
    private BaseDelegateLoader exported;
    private Map<String, Loader> classCache;
    private Map<String, String> classBlackList;
    private Map<String, URL> resourceCache;
    private Map<String, String> resourceBlackList;

    public ClassLoaderInformation(BaseClassLoader classLoader, BaseClassLoaderPolicy policy, int order) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        this.classLoader = classLoader;
        this.policy = policy;
        this.order = order;
        this.exported = policy.getExported();
        this.delegates = policy.getDelegates();
        boolean canCache = policy.isCacheable();
        boolean canBlackList = policy.isBlackListable();
        if (this.delegates != null && !this.delegates.isEmpty()) {
            for (DelegateLoader delegateLoader : this.delegates) {
                if (delegateLoader == null) {
                    throw new IllegalStateException(policy + " null delegate in " + this.delegates);
                }
                DelegateLoader baseDelegate = delegateLoader;
                BaseClassLoaderPolicy delegatePolicy = baseDelegate.getPolicy();
                if (delegatePolicy == null || !delegatePolicy.isCacheable()) {
                    canCache = false;
                }
                if (delegatePolicy != null && delegatePolicy.isBlackListable()) continue;
                canBlackList = false;
            }
        }
        if (canCache) {
            this.classCache = new ConcurrentHashMap<String, Loader>();
            this.resourceCache = new ConcurrentHashMap<String, URL>();
        }
        if (canBlackList) {
            this.classBlackList = new ConcurrentHashMap<String, String>();
            this.resourceBlackList = new ConcurrentHashMap<String, String>();
        }
    }

    public void flushCaches() {
        if (this.classCache != null) {
            this.classCache.clear();
        }
        if (this.classBlackList != null) {
            this.classBlackList.clear();
        }
        if (this.resourceCache != null) {
            this.resourceCache.clear();
        }
        if (this.resourceBlackList != null) {
            this.resourceBlackList.clear();
        }
    }

    public BaseClassLoader getClassLoader() {
        return this.classLoader;
    }

    public BaseClassLoaderPolicy getPolicy() {
        return this.policy;
    }

    public int getOrder() {
        return this.order;
    }

    public BaseDelegateLoader getExported() {
        return this.exported;
    }

    public List<? extends DelegateLoader> getDelegates() {
        return this.delegates;
    }

    public Loader getCachedLoader(String name) {
        Map<String, Loader> classCache = this.classCache;
        if (classCache != null) {
            return classCache.get(name);
        }
        return null;
    }

    public void cacheLoader(String name, Loader loader) {
        Map<String, Loader> classCache = this.classCache;
        if (classCache != null) {
            classCache.put(name, loader);
        }
    }

    public boolean isBlackListedClass(String name) {
        Map<String, String> classBlackList = this.classBlackList;
        if (classBlackList != null) {
            return classBlackList.containsKey(name);
        }
        return false;
    }

    public void blackListClass(String name) {
        Map<String, String> classBlackList = this.classBlackList;
        if (classBlackList != null) {
            classBlackList.put(name, name);
        }
    }

    public URL getCachedResource(String name) {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache != null) {
            return resourceCache.get(name);
        }
        return null;
    }

    public void cacheResource(String name, URL url) {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache != null) {
            resourceCache.put(name, url);
        }
    }

    public boolean isBlackListedResource(String name) {
        Map<String, String> resourceBlackList = this.resourceBlackList;
        if (resourceBlackList != null) {
            return resourceBlackList.containsKey(name);
        }
        return false;
    }

    public void blackListResource(String name) {
        Map<String, String> resourceBlackList = this.resourceBlackList;
        if (resourceBlackList != null) {
            resourceBlackList.put(name, name);
        }
    }

    public String toString() {
        return this.policy.toString();
    }
}

