/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.ImportType;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseDelegateLoader;
import org.jboss.util.collection.ConcurrentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderInformation {
    private BaseClassLoader classLoader;
    private BaseClassLoaderPolicy policy;
    private int order;
    private Map<ImportType, List<DelegateLoader>> delegates;
    private BaseDelegateLoader exported;
    private Map<String, Loader> classCache;
    private Set<String> classBlackList;
    private Map<String, URL> resourceCache;
    private Set<String> resourceBlackList;

    public ClassLoaderInformation(BaseClassLoader classLoader, BaseClassLoaderPolicy policy, int order) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        this.classLoader = classLoader;
        this.policy = policy;
        this.order = order;
        this.exported = policy.getExported();
        boolean canCache = policy.isCacheable();
        boolean canBlackList = policy.isBlackListable();
        List<? extends DelegateLoader> delegates = policy.getDelegates();
        if (delegates != null && !delegates.isEmpty()) {
            this.delegates = new HashMap<ImportType, List<DelegateLoader>>();
            ArrayList<DelegateLoader> all = new ArrayList<DelegateLoader>();
            this.delegates.put(ImportType.ALL, all);
            for (DelegateLoader delegateLoader : delegates) {
                if (delegateLoader == null) {
                    throw new IllegalStateException(policy + " null delegate in " + delegates);
                }
                ImportType importType = delegateLoader.getImportType();
                List<DelegateLoader> loaders = this.delegates.get((Object)importType);
                if (loaders == null) {
                    loaders = new ArrayList<DelegateLoader>();
                    this.delegates.put(importType, loaders);
                }
                loaders.add(delegateLoader);
                all.add(delegateLoader);
                DelegateLoader baseDelegate = delegateLoader;
                BaseClassLoaderPolicy delegatePolicy = ((BaseDelegateLoader)baseDelegate).getPolicy();
                if (delegatePolicy == null || !delegatePolicy.isCacheable()) {
                    canCache = false;
                }
                if (delegatePolicy != null && delegatePolicy.isBlackListable()) continue;
                canBlackList = false;
            }
        }
        if (canCache) {
            this.classCache = new ConcurrentHashMap<String, Loader>();
            this.resourceCache = new ConcurrentHashMap<String, URL>();
        }
        if (canBlackList) {
            this.classBlackList = new ConcurrentSet();
            this.resourceBlackList = new ConcurrentSet();
        }
    }

    public void flushCaches() {
        if (this.classCache != null) {
            this.classCache.clear();
        }
        if (this.classBlackList != null) {
            this.classBlackList.clear();
        }
        if (this.resourceCache != null) {
            this.resourceCache.clear();
        }
        if (this.resourceBlackList != null) {
            this.resourceBlackList.clear();
        }
    }

    public BaseClassLoader getClassLoader() {
        return this.classLoader;
    }

    public BaseClassLoaderPolicy getPolicy() {
        return this.policy;
    }

    public int getOrder() {
        return this.order;
    }

    public BaseDelegateLoader getExported() {
        return this.exported;
    }

    @Deprecated
    public List<? extends DelegateLoader> getDelegates() {
        return this.getDelegates(ImportType.BEFORE);
    }

    public List<? extends DelegateLoader> getDelegates(ImportType type) {
        if (this.delegates == null) {
            return Collections.emptyList();
        }
        return this.delegates.get((Object)type);
    }

    public Loader getCachedLoader(String name) {
        Map<String, Loader> classCache = this.classCache;
        if (classCache != null) {
            return classCache.get(name);
        }
        return null;
    }

    public void cacheLoader(String name, Loader loader) {
        Map<String, Loader> classCache = this.classCache;
        if (classCache != null) {
            classCache.put(name, loader);
        }
    }

    public boolean isBlackListedClass(String name) {
        Set<String> classBlackList = this.classBlackList;
        return classBlackList != null && classBlackList.contains(name);
    }

    public void blackListClass(String name) {
        Set<String> classBlackList = this.classBlackList;
        if (classBlackList != null) {
            classBlackList.add(name);
        }
    }

    public URL getCachedResource(String name) {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache != null) {
            return resourceCache.get(name);
        }
        return null;
    }

    public void cacheResource(String name, URL url) {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache != null) {
            resourceCache.put(name, url);
        }
    }

    public boolean isBlackListedResource(String name) {
        Set<String> resourceBlackList = this.resourceBlackList;
        return resourceBlackList != null && resourceBlackList.contains(name);
    }

    public void blackListResource(String name) {
        Set<String> resourceBlackList = this.resourceBlackList;
        if (resourceBlackList != null) {
            resourceBlackList.add(name);
        }
    }

    public void clearBlackList(String name) {
        if (this.classBlackList != null) {
            this.classBlackList.remove(name);
        }
        if (this.resourceBlackList != null) {
            this.resourceBlackList.remove(name);
        }
    }

    public String toString() {
        return this.policy.toString();
    }
}

