/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.jboss.classpool.base.BaseClassPool;
import org.jboss.classpool.base.BaseClassPoolDomain;
import org.jboss.classpool.base.DefaultClassLoaderIsLocalResourcePlugin;
import org.jboss.classpool.base.DefaultClassLoaderIsLocalResourcePluginFactory;
import org.jboss.classpool.base.IsLocalResourcePlugin;
import org.jboss.classpool.base.IsLocalResourcePluginFactory;
import org.jboss.classpool.base.IsLocalResourcePluginFactoryRegistry;
import org.jboss.classpool.base.TranslatableClassLoaderIsLocalResourcePlugin;
import org.jboss.classpool.base.TranslatableClassLoaderIsLocalResourcePluginFactory;
import org.jboss.classpool.base.URLClassLoaderIsLocalResourcePlugin;
import org.jboss.classpool.base.URLClassLoaderIsLocalResourcePluginFactory;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.util.loading.Translatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsLocalResourcePluginFactoryTestCase
extends TestCase {
    static final ClassPoolDomain DOMAIN = new BaseClassPoolDomain("Test", null, true);
    static final URL[] URLS;
    private Collection<ClassLoader> createdClassLoaders = new HashSet<ClassLoader>();

    public IsLocalResourcePluginFactoryTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            this.createdClassLoaders.clear();
        }
    }

    public void testDefaultClassLoader() {
        DefaultClassLoader classLoader = new DefaultClassLoader();
        this.assertFactoryAndPlugin(classLoader, DefaultClassLoaderIsLocalResourcePluginFactory.class, DefaultClassLoaderIsLocalResourcePlugin.class);
    }

    public void testURLClassLoaderDirect() {
        URLClassLoader classLoader = new URLClassLoader(URLS);
        this.assertFactoryAndPlugin(classLoader, URLClassLoaderIsLocalResourcePluginFactory.class, URLClassLoaderIsLocalResourcePlugin.class);
    }

    public void testURLClassLoaderSubClass() {
        URLCLassLoaderSubClass classLoader = new URLCLassLoaderSubClass(URLS);
        this.assertFactoryAndPlugin(classLoader, URLClassLoaderIsLocalResourcePluginFactory.class, URLClassLoaderIsLocalResourcePlugin.class);
    }

    public void testTranslatableClassLoaderImplementation() {
        TranslatableImplementation classLoader = new TranslatableImplementation();
        this.assertFactoryAndPlugin(classLoader, TranslatableClassLoaderIsLocalResourcePluginFactory.class, TranslatableClassLoaderIsLocalResourcePlugin.class);
    }

    public void testTranslatableClassLoaderImplementationAndURLClassLoaderSubClass() {
        TranslatableImplementationAndURLClassLoaderSubClass classLoader = new TranslatableImplementationAndURLClassLoaderSubClass(URLS);
        this.assertFactoryAndPlugin(classLoader, TranslatableClassLoaderIsLocalResourcePluginFactory.class, TranslatableClassLoaderIsLocalResourcePlugin.class);
    }

    public void testTranslatable2ClassLoaderImplementationAndURLClassLoaderSubClass() {
        Translatable2ImplementationAndURLClassLoaderSubClass classLoader = new Translatable2ImplementationAndURLClassLoaderSubClass(URLS);
        this.assertFactoryAndPlugin(classLoader, TranslatableClassLoaderIsLocalResourcePluginFactory.class, TranslatableClassLoaderIsLocalResourcePlugin.class);
    }

    private void assertFactoryAndPlugin(ClassLoader classLoader, Class<?> factoryClass, Class<?> pluginClass) {
        this.createdClassLoaders.add(classLoader);
        DelegatingClassPool pool = new DelegatingClassPool(DOMAIN, classLoader, AbstractClassPoolFactory.getSystemClassPool(), (ScopedClassPoolRepository)ClassPoolRepository.getInstance());
        IsLocalResourcePluginFactory factory = IsLocalResourcePluginFactoryRegistry.getPluginFactory((ClassLoader)pool.getClassLoader());
        IsLocalResourcePluginFactoryTestCase.assertNotNull((Object)factory);
        IsLocalResourcePluginFactoryTestCase.assertEquals(factoryClass, factory.getClass());
        IsLocalResourcePlugin plugin = factory.create((BaseClassPool)pool);
        IsLocalResourcePluginFactoryTestCase.assertEquals(pluginClass, plugin.getClass());
    }

    static {
        try {
            URLS = new URL[]{new URL("http://www.blah.com")};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static class Translatable2ImplementationAndURLClassLoaderSubClass
    extends URLClassLoader
    implements Translatable2 {
        public Translatable2ImplementationAndURLClassLoaderSubClass(URL[] urls) {
            super(urls);
        }

        public URL getResourceLocally(String name) {
            return null;
        }
    }

    static interface Translatable2
    extends Translatable {
    }

    static class TranslatableImplementationAndURLClassLoaderSubClass
    extends URLClassLoader
    implements Translatable {
        public TranslatableImplementationAndURLClassLoaderSubClass(URL[] urls) {
            super(urls);
        }

        public URL getResourceLocally(String name) {
            return null;
        }
    }

    static class TranslatableImplementation
    extends ClassLoader
    implements Translatable {
        TranslatableImplementation() {
        }

        public URL getResourceLocally(String name) {
            return null;
        }
    }

    static class URLCLassLoaderSubClass
    extends URLClassLoader {
        public URLCLassLoaderSubClass(URL[] urls) {
            super(urls);
        }
    }

    static class DefaultClassLoader
    extends ClassLoader {
        DefaultClassLoader() {
        }
    }
}

