/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.base;

import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.base.ParentDelegationStrategy;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolToClassPoolDomainAdaptorFactory;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.logging.Logger;

public abstract class AbstractParentDelegationStrategy
implements ParentDelegationStrategy {
    protected final Logger logger = Logger.getLogger((String)this.getClass().getName());
    private ClassPoolDomain domain;
    private ClassPoolDomain parent;

    protected AbstractParentDelegationStrategy(ClassPoolDomain parent, ClassPoolToClassPoolDomainAdaptorFactory adaptorFactory) {
        if (parent == null) {
            if (adaptorFactory == null) {
                throw new IllegalStateException("Null parent and null adaptorFactory");
            }
            this.parent = adaptorFactory.createAdaptor();
        } else {
            if (!(parent instanceof AbstractClassPoolDomain)) {
                throw new IllegalArgumentException("Parent must implement AbstractClassPoolDomain");
            }
            this.parent = parent;
        }
        if (this.parent == null) {
            throw new IllegalStateException("Parent was not set");
        }
    }

    protected AbstractParentDelegationStrategy(ClassPool parent, ClassPoolToClassPoolDomainAdaptorFactory adaptorFactory) {
        this.parent = adaptorFactory.createAdaptor(parent);
    }

    protected boolean hasParent() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this + " " + this.getDomain() + " hasParent " + this.parent != null ? 1 : 0));
        }
        return this.parent != null;
    }

    protected ClassPoolDomain getDomain() {
        return this.domain;
    }

    public CtClass getCachedOrCreateFromParent(DelegatingClassPool initiatingPool, String classname, String resourceName, boolean create, boolean trace) {
        return this.parent.getCachedOrCreate(initiatingPool, classname, resourceName, create, trace);
    }

    public void setDomain(ClassPoolDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        if (this.domain != null) {
            throw new IllegalArgumentException("Cannot change domain");
        }
        this.domain = domain;
    }

    public int getParentModCount() {
        return this.parent.getModCount();
    }
}

